/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.studio;

import com.atlassian.jira.plugin.studio.RemoteProjects;
import com.atlassian.jira.util.json.JSONException;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteProjectsStorage {
    static final String SESSION_KEY = "com.atlassian.jira.plugin.studio.RemoteProjectsStorage";
    private final Logger logger = LoggerFactory.getLogger(RemoteProjectsStorage.class);
    private final HttpSession session;

    public RemoteProjectsStorage(@Nullable HttpSession session) {
        this.session = session;
    }

    @Nullable
    public static RemoteProjectsStorage createFromHttpServletRequest(@Nonnull HttpServletRequest request) {
        HttpSession session = request.getSession();
        return session != null ? new RemoteProjectsStorage(session) : null;
    }

    public void push(@Nonnull RemoteProjects remoteProjects) {
        this.pushValueToSession(this.serialize(remoteProjects));
    }

    @Nullable
    private String serialize(@Nonnull RemoteProjects remoteProjects) {
        try {
            return remoteProjects.serialize();
        }
        catch (JSONException e) {
            this.logger.debug("Failed to serialize remote projects", (Throwable)e);
            return null;
        }
    }

    private void pushValueToSession(@Nullable String payload) {
        if (this.session != null && payload != null) {
            this.session.setAttribute(SESSION_KEY, (Object)payload);
        }
    }

    @Nullable
    public RemoteProjects pop() {
        return this.deserialize(this.popValueFromSession());
    }

    @Nullable
    private Object popValueFromSession() {
        if (this.session != null) {
            Object attribute = this.session.getAttribute(SESSION_KEY);
            this.session.removeAttribute(SESSION_KEY);
            return attribute;
        }
        return null;
    }

    @Nullable
    private RemoteProjects deserialize(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        try {
            return RemoteProjects.deserialize(Strings.nullToEmpty((String)o.toString()));
        }
        catch (JSONException e) {
            this.logger.debug("Failed to deserialize remote projects", (Throwable)e);
            return null;
        }
    }
}

