/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import java.util.ArrayList;

public abstract class AbstractUrlFragmentUtil<T> {
    private final SearchRequest searchRequest;
    private final User user;
    private final String baseUrl;
    private String allUrl;

    public AbstractUrlFragmentUtil(SearchRequest searchRequest, User user, ApplicationProperties applicationProperties) {
        this.searchRequest = searchRequest;
        this.user = user;
        this.baseUrl = this.createBaseUrl(applicationProperties);
        this.allUrl = null;
    }

    protected abstract Clause getDomainClause(T var1);

    protected abstract OrderBy getOrderBy();

    public String getUrl(T domain) {
        Query orgQuery = this.searchRequest.getQuery();
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
        if (orgQuery.getWhereClause() != null) {
            builder.addClause(orgQuery.getWhereClause()).and();
        }
        builder.addClause(this.getDomainClause(domain));
        return this.getLink(builder.buildClause(), orgQuery.getOrderByClause());
    }

    public String getAllUrl() {
        if (this.allUrl == null) {
            this.allUrl = this.createAllUrl();
        }
        return this.allUrl;
    }

    String createAllUrl() {
        Query orgQuery = this.searchRequest.getQuery();
        JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
        ArrayList sorts = new ArrayList();
        sorts.addAll(this.getOrderBy().getSearchSorts());
        if (orgQuery.getOrderByClause() != null) {
            sorts.addAll(orgQuery.getOrderByClause().getSearchSorts());
        }
        jqlOrderByBuilder.setSorts(sorts);
        return this.getLink(orgQuery.getWhereClause(), jqlOrderByBuilder.buildOrderBy());
    }

    String getLink(Clause whereClause, OrderBy orderBy) {
        SearchRequest newSearchRequest = new SearchRequest(this.searchRequest);
        newSearchRequest.setQuery((Query)new QueryImpl(whereClause, orderBy, null));
        StringBuilder link = new StringBuilder();
        link.append(SearchRequestViewUtils.getLink(newSearchRequest, this.baseUrl, this.user)).append("&mode=hide");
        return link.toString();
    }

    String createBaseUrl(ApplicationProperties applicationProperties) {
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(applicationProperties).getJiraVelocityRequestContext();
        return velocityRequestContext.getBaseUrl();
    }
}

