/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.ofbiz.ChainedSQLInterceptor;
import com.atlassian.jira.ofbiz.InstrumentedSQLInterceptor;
import com.atlassian.jira.ofbiz.LoggingSQLInterceptor;
import com.atlassian.jira.ofbiz.PerformanceSQLInterceptor;
import com.atlassian.jira.security.xsrf.XsrfVulnerabilityDetectionSQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptorFactory;

public class JiraSQLInterceptorFactory
implements SQLInterceptorFactory {
    private final boolean showPerformanceMonitor = JiraSystemProperties.showPerformanceMonitor();

    public SQLInterceptor newSQLInterceptor(String ofbizHelperName) {
        ChainedSQLInterceptor.Builder builder = new ChainedSQLInterceptor.Builder();
        builder.add(new LoggingSQLInterceptor()).add(new InstrumentedSQLInterceptor()).add(new XsrfVulnerabilityDetectionSQLInterceptor());
        if (this.showPerformanceMonitor) {
            builder.add(new PerformanceSQLInterceptor());
        }
        return builder.build();
    }
}

