/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.NotificationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.PermissionJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.notification.NotificationBuilderImpl;
import com.atlassian.jira.notification.NotificationFilter;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class AdhocNotificationServiceImpl
implements AdhocNotificationService {
    private final MailService mailService;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final WatcherService watcherService;
    private final VoteService voteService;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final NotificationSchemeManager notificationSchemeManager;
    private final NotificationFilterManager notificationFilterManager;

    public AdhocNotificationServiceImpl(MailService mailService, UserManager userManager, GroupManager groupManager, WatcherService watcherService, VoteService voteService, PermissionManager permissionManager, I18nHelper.BeanFactory i18nBeanFactory, NotificationSchemeManager notificationSchemeManager, NotificationFilterManager notificationFilterManager) {
        this.notificationFilterManager = notificationFilterManager;
        this.mailService = (MailService)Preconditions.checkNotNull((Object)mailService);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager);
        this.watcherService = (WatcherService)Preconditions.checkNotNull((Object)watcherService);
        this.voteService = (VoteService)Preconditions.checkNotNull((Object)voteService);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.i18nBeanFactory = (I18nHelper.BeanFactory)Preconditions.checkNotNull((Object)i18nBeanFactory);
        this.notificationSchemeManager = (NotificationSchemeManager)Preconditions.checkNotNull((Object)notificationSchemeManager);
    }

    public NotificationBuilder makeBuilder() {
        return new NotificationBuilderImpl();
    }

    public static ServiceOutcome<NotificationBuilder> makeBuilder(NotificationBuilder notificationBuilder, NotificationJsonBean jsonBean, I18nHelper i18nHelper) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        List<Permissions.Permission> permissions = AdhocNotificationServiceImpl.toPermissions(jsonBean.getRestrict().getPermissions(), (ErrorCollection)errors, i18nHelper);
        return ServiceOutcomeImpl.from((ErrorCollection)errors, notificationBuilder.setTemplate("issuenotify.vm").setTemplateParams(ImmutableMap.of((Object)"subject", (Object)StringUtils.defaultString((String)jsonBean.getSubject()), (Object)"textBody", (Object)StringUtils.defaultString((String)jsonBean.getTextBody()), (Object)"htmlBody", (Object)StringUtils.defaultString((String)jsonBean.getHtmlBody()))).setToReporter(jsonBean.getTo().isReporter()).setToAssignee(jsonBean.getTo().isAssignee()).setToWatchers(jsonBean.getTo().isWatchers()).setToVoters(jsonBean.getTo().isVoters()).addToGroups(AdhocNotificationServiceImpl.toGroupNames(jsonBean.getTo().getGroups())).addToUsers(AdhocNotificationServiceImpl.toUsernames(jsonBean.getTo().getUsers())).addRestrictGroups(AdhocNotificationServiceImpl.toGroupNames(jsonBean.getRestrict().getGroups())).addRestrictPermissions(permissions));
    }

    private static List<String> toUsernames(List<UserJsonBean> users) {
        return Lists.transform(users, (Function)new Function<UserJsonBean, String>(){

            public String apply(UserJsonBean input) {
                return input.getName();
            }
        });
    }

    private static List<String> toGroupNames(List<GroupJsonBean> groups) {
        return Lists.transform(groups, (Function)new Function<GroupJsonBean, String>(){

            public String apply(GroupJsonBean input) {
                return input.getName();
            }
        });
    }

    private static List<Permissions.Permission> toPermissions(List<PermissionJsonBean> permissionBeans, ErrorCollection errors, I18nHelper i18nHelper) {
        ArrayList permissions = Lists.newArrayList();
        for (PermissionJsonBean permissionBean : permissionBeans) {
            Permissions.Permission p = permissionBean.asPermission();
            if (p != null) {
                permissions.add(p);
                continue;
            }
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.unknown.permission", (Object)permissionBean));
        }
        return permissions;
    }

    public AdhocNotificationService.ValidateNotificationResult validateNotification(NotificationBuilder notification, User user, Issue issue) {
        return this.validateNotification(notification, user, issue, AdhocNotificationService.ValiationOption.FAIL_ON_NO_RECIPIENTS);
    }

    public AdhocNotificationService.ValidateNotificationResult validateNotification(final NotificationBuilder notification, final User user, final Issue issue, AdhocNotificationService.ValiationOption option) {
        Supplier recipients = Suppliers.memoize((Supplier)new Supplier<Iterable<NotificationRecipient>>(){

            public Iterable<NotificationRecipient> get() {
                return AdhocNotificationServiceImpl.this.getRecipients(user, issue, notification);
            }
        });
        ErrorCollection errors = this.validate((Supplier<Iterable<NotificationRecipient>>)recipients, notification, user, issue, option);
        return new AdhocNotificationService.ValidateNotificationResult(errors, notification, recipients, user, issue);
    }

    private ErrorCollection validate(Supplier<Iterable<NotificationRecipient>> recipients, NotificationBuilder notification, User remoteUser, Issue issue, AdhocNotificationService.ValiationOption option) {
        Iterable unknwonGroups;
        Iterable unknownUsers;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(remoteUser);
        if (!this.permissionManager.hasPermission(10, issue, remoteUser)) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.no.browse.permission", issue.getKey()));
        }
        if (!Iterables.isEmpty((Iterable)(unknownUsers = Iterables.filter((Iterable)notification.getToUsers(), (Predicate)new UnknownUserPredicate(this.userManager))))) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.unknown.users", (Object)unknownUsers));
        }
        if (!Iterables.isEmpty((Iterable)(unknwonGroups = Iterables.filter((Iterable)Iterables.concat((Iterable)notification.getToGroups(), (Iterable)notification.getRestrictGroups()), (Predicate)new UnknownGroupPredicate(this.groupManager))))) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.unknown.groups", (Object)unknwonGroups));
        }
        if (AdhocNotificationService.ValiationOption.FAIL_ON_NO_RECIPIENTS.equals((Object)option) && !errors.hasAnyErrors() && Iterables.isEmpty((Iterable)((Iterable)recipients.get()))) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.no.recipients"));
        }
        return errors;
    }

    public void sendNotification(AdhocNotificationService.ValidateNotificationResult result) {
        if (!result.isValid()) {
            throw new IllegalStateException("Validation result was not valid.");
        }
        this.sendNotification(result.from, (Iterable)result.recipients.get(), (Map<String, Object>)this.getParams(result.from, result.issue, result.notification), result.notification.getTemplate());
    }

    private void sendNotification(User from, Iterable<NotificationRecipient> recipients, Map<String, Object> params, String template) {
        NotificationFilter.Context context = new NotificationFilter.Context(NotificationFilter.Reason.ADHOC_NOTIIFCATION);
        for (NotificationRecipient recipient : recipients) {
            if (this.notificationFilterManager.filter(recipient, context)) continue;
            String bodyTemplatePath = "templates/email/" + recipient.getFormat() + "/" + template;
            this.mailService.sendRenderedMail(from, recipient, "templates/email/subject/" + template, bodyTemplatePath, params);
        }
    }

    private Iterable<NotificationRecipient> getRecipients(User remoteUser, Issue issue, NotificationBuilder notification) {
        if (this.noRecipientsDefined(notification)) {
            return this.getRecipientsFromNotificationScheme(remoteUser, issue);
        }
        return this.getRecipientsFromNotification(remoteUser, issue, notification);
    }

    private boolean noRecipientsDefined(NotificationBuilder notification) {
        return !notification.isToReporter() && !notification.isToAssignee() && !notification.isToVoters() && !notification.isToWatchers() && notification.getToEmails().isEmpty() && notification.getToUsers().isEmpty() && notification.getToGroups().isEmpty();
    }

    private Iterable<NotificationRecipient> getRecipientsFromNotificationScheme(User remoteUser, Issue issue) {
        return this.notificationSchemeManager.getRecipients(new IssueEvent(issue, (Map)ImmutableMap.of(), remoteUser, EventType.ISSUE_GENERICEVENT_ID));
    }

    private Iterable<NotificationRecipient> getRecipientsFromNotification(User remoteUser, Issue issue, NotificationBuilder notification) {
        ImmutableList.Builder recipients = ImmutableList.builder().addAll(this.getEmailRecipients(notification)).addAll(this.getUserRecipients(notification)).addAll(this.getGroupRecipients(notification));
        if (notification.isToReporter()) {
            recipients.add((Object)new NotificationRecipient(issue.getReporter()));
        }
        if (notification.isToAssignee()) {
            recipients.add((Object)new NotificationRecipient(issue.getAssignee()));
        }
        if (notification.isToWatchers()) {
            recipients.addAll(this.getWatchersRecipients(remoteUser, issue));
        }
        if (notification.isToVoters()) {
            recipients.addAll(this.getVotersRecipients(remoteUser, issue));
        }
        return this.restrict(this.removeRemoteUserIfNecessary((Iterable<NotificationRecipient>)recipients.build(), remoteUser), issue, notification);
    }

    private Iterable<NotificationRecipient> removeRemoteUserIfNecessary(Iterable<NotificationRecipient> recipients, User user) {
        if (user != null && !new JiraUserPreferences(user).getBoolean("user.notify.own.changes")) {
            final NotificationRecipient userRecipient = new NotificationRecipient(user);
            return Iterables.filter(recipients, (Predicate)new Predicate<NotificationRecipient>(){

                public boolean apply(NotificationRecipient recipient) {
                    return !recipient.equals((Object)userRecipient);
                }
            });
        }
        return recipients;
    }

    private Iterable<NotificationRecipient> restrict(Iterable<NotificationRecipient> recipients, Issue issue, NotificationBuilder notification) {
        ArrayList permissions;
        Iterable restricted = recipients;
        ArrayList groups = Lists.newArrayList((Iterable)notification.getRestrictGroups());
        if (!groups.isEmpty()) {
            restricted = Iterables.filter(restricted, (Predicate)new NotificationRecipientInAnyGroupPredicate(groups, this.groupManager));
        }
        if (!(permissions = Lists.newArrayList((Iterable)notification.getRestrictPermissions())).isEmpty()) {
            restricted = Iterables.filter((Iterable)restricted, (Predicate)new NotificationRecipientHasAnyPermissionPredicate(permissions, issue, this.permissionManager));
        }
        return restricted;
    }

    private Iterable<NotificationRecipient> getVotersRecipients(User remoteUser, Issue issue) {
        return Iterables.transform((Iterable)((Iterable)this.voteService.viewVoters(issue, remoteUser).getReturnedValue()), (Function)new UserToNotificationRecipientFunction());
    }

    private Iterable<NotificationRecipient> getWatchersRecipients(User remoteUser, Issue issue) {
        return Iterables.transform((Iterable)((Iterable)((Pair)this.watcherService.getWatchers(issue, remoteUser).getReturnedValue()).second()), (Function)new UserToNotificationRecipientFunction());
    }

    private Iterable<NotificationRecipient> getGroupRecipients(NotificationBuilder notification) {
        return Iterables.concat((Iterable)Iterables.transform((Iterable)notification.getToGroups(), (Function)new GroupNameToNotificationRecipientIterableFunction(this.groupManager)));
    }

    private Iterable<NotificationRecipient> getUserRecipients(NotificationBuilder notificationBean) {
        return Iterables.transform((Iterable)Iterables.transform((Iterable)notificationBean.getToUsers(), (Function)new UserNameToUserFunction(this.userManager)), (Function)new UserToNotificationRecipientFunction());
    }

    private Iterable<NotificationRecipient> getEmailRecipients(NotificationBuilder notificationBuilder) {
        return Iterables.transform((Iterable)notificationBuilder.getToEmails(), (Function)new EmailToNotificationRecipientFunction());
    }

    private ImmutableMap<String, Object> getParams(User from, Issue issue, NotificationBuilder notification) {
        return ImmutableMap.builder().put((Object)"issue", (Object)issue).put((Object)"remoteUser", (Object)from).putAll((Map)notification.getTemplateParams()).build();
    }

    private static class UnknownGroupPredicate
    implements Predicate<String> {
        private final GroupManager groupManager;

        public UnknownGroupPredicate(GroupManager groupManager) {
            this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager);
        }

        public boolean apply(String userName) {
            return !this.groupManager.groupExists(userName);
        }
    }

    private static class UnknownUserPredicate
    implements Predicate<String> {
        private final UserManager userManager;

        public UnknownUserPredicate(UserManager userManager) {
            this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        }

        public boolean apply(String userName) {
            return this.userManager.getUser(userName) == null;
        }
    }

    private static class NotificationRecipientHasAnyPermissionPredicate
    implements Predicate<NotificationRecipient> {
        private final List<Permissions.Permission> permissions;
        private final Issue issue;
        private final PermissionManager permissionManager;

        public NotificationRecipientHasAnyPermissionPredicate(List<Permissions.Permission> permissions, Issue issue, PermissionManager permissionManager) {
            this.permissions = (List)Preconditions.checkNotNull(permissions);
            this.issue = (Issue)Preconditions.checkNotNull((Object)issue);
            this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        }

        public boolean apply(NotificationRecipient recipient) {
            User recipientUser = recipient.getUserRecipient();
            return recipientUser != null && Iterables.any(this.permissions, (Predicate)new HasIssuePermissionPredicate(this.issue, recipientUser, this.permissionManager));
        }
    }

    private static final class HasIssuePermissionPredicate
    implements Predicate<Permissions.Permission> {
        private final Issue issue;
        private final User user;
        private final PermissionManager permissionManager;

        public HasIssuePermissionPredicate(Issue issue, User user, PermissionManager permissionManager) {
            this.issue = (Issue)Preconditions.checkNotNull((Object)issue);
            this.user = (User)Preconditions.checkNotNull((Object)user);
            this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        }

        public boolean apply(Permissions.Permission permission) {
            return this.permissionManager.hasPermission(permission.getId(), this.issue, this.user);
        }
    }

    private static final class NotificationRecipientInAnyGroupPredicate
    implements Predicate<NotificationRecipient> {
        private final GroupManager groupManager;
        private final List<String> groups;

        public NotificationRecipientInAnyGroupPredicate(List<String> groups, GroupManager groupManager) {
            this.groups = (List)Preconditions.checkNotNull(groups);
            this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager);
        }

        public boolean apply(NotificationRecipient recipient) {
            User recipientUser = recipient.getUserRecipient();
            return recipientUser != null && Iterables.any(this.groups, (Predicate)new UserInGroupPredicate(recipientUser, this.groupManager));
        }
    }

    private static class UserInGroupPredicate
    implements Predicate<String> {
        private final User user;
        private final GroupManager groupManager;

        public UserInGroupPredicate(User user, GroupManager groupManager) {
            this.user = (User)Preconditions.checkNotNull((Object)user);
            this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager);
        }

        public boolean apply(String groupName) {
            return this.groupManager.isUserInGroup(this.user.getName(), groupName);
        }
    }

    private static class UserNameToUserFunction
    implements Function<String, User> {
        private final UserManager userManager;

        private UserNameToUserFunction(UserManager userManager) {
            this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        }

        public User apply(String userName) {
            return this.userManager.getUser(userName);
        }
    }

    private static final class GroupNameToNotificationRecipientIterableFunction
    implements Function<String, Iterable<NotificationRecipient>> {
        private final GroupManager groupManager;

        private GroupNameToNotificationRecipientIterableFunction(GroupManager groupManager) {
            this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager);
        }

        public Iterable<NotificationRecipient> apply(String group) {
            return Iterables.transform((Iterable)this.groupManager.getUsersInGroup(group), (Function)new UserToNotificationRecipientFunction());
        }
    }

    private static final class UserToNotificationRecipientFunction
    implements Function<User, NotificationRecipient> {
        private UserToNotificationRecipientFunction() {
        }

        public NotificationRecipient apply(User user) {
            return new NotificationRecipient(user);
        }
    }

    private static final class EmailToNotificationRecipientFunction
    implements Function<String, NotificationRecipient> {
        private EmailToNotificationRecipientFunction() {
        }

        public NotificationRecipient apply(String email) {
            return new NotificationRecipient(email);
        }
    }
}

