/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.util.JqlDateSupportImpl;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

class DateValueValidator {
    private final JqlOperandResolver operandResolver;
    private final JqlDateSupport support;

    DateValueValidator(JqlOperandResolver operandResolver, JqlDateSupport support) {
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.support = (JqlDateSupport)Assertions.notNull((String)"support", (Object)support);
    }

    DateValueValidator(JqlOperandResolver operandResolver, TimeZoneManager timeZoneManager) {
        this(operandResolver, new JqlDateSupportImpl(timeZoneManager));
    }

    MessageSet validate(User searcher, TerminalClause terminalClause) {
        Assertions.notNull((String)"terminalClause", (Object)terminalClause);
        Operand operand = terminalClause.getOperand();
        MessageSetImpl messages = new MessageSetImpl();
        if (this.operandResolver.isValidOperand(operand)) {
            I18nHelper i18n = this.getI18n(searcher);
            List values = this.operandResolver.getValues(searcher, operand, terminalClause);
            String fieldName = terminalClause.getName();
            for (QueryLiteral value : values) {
                boolean result;
                String str = value.getStringValue();
                if (str == null || (result = this.support.validate(str))) continue;
                String msg = this.operandResolver.isFunctionOperand(value.getSourceOperand()) ? i18n.getText("jira.jql.clause.date.format.invalid.from.func", fieldName, value.getSourceOperand().getName()) : i18n.getText("jira.jql.clause.date.format.invalid", str, fieldName);
                messages.addErrorMessage(msg);
            }
        }
        return messages;
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

