/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.DefaultConfiguration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Indexes;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryFieldConstants;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.jql.operand.EmptyWasClauseOperandHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ChangedClauseQueryFactory;
import com.atlassian.jira.jql.query.DefaultLuceneQueryBuilder;
import com.atlassian.jira.jql.query.HistoryPredicateQueryFactory;
import com.atlassian.jira.jql.query.IssueQueryMatcherService;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.query.QueryRegistry;
import com.atlassian.jira.jql.query.WasClauseQueryFactory;
import com.atlassian.jira.jql.resolver.ChangeHistoryFieldIdResolver;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.query.clause.Clause;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class DefaultIssueQueryMatcherService
implements IssueQueryMatcherService {
    private final ApplicationProperties applicationProperties;
    private final QueryRegistry queryRegistry;
    private final LuceneQueryModifier luceneQueryModifier;
    private final JqlOperandResolver jqlOperandResolver;
    private final HistoryPredicateQueryFactory historyPredicateQueryFactory;
    private final EmptyWasClauseOperandHandler emptyWasClauseOperandHandler;
    private final ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver;
    private final ChangeHistoryFieldConstants changeHistoryFieldConstants;

    public DefaultIssueQueryMatcherService(LuceneQueryModifier luceneQueryModifier, QueryRegistry queryRegistry, ApplicationProperties applicationProperties, JqlOperandResolver jqlOperandResolver, HistoryPredicateQueryFactory historyPredicateQueryFactory, EmptyWasClauseOperandHandler emptyWasClauseOperandHandler, ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver, ChangeHistoryFieldConstants changeHistoryFieldConstants) {
        this.luceneQueryModifier = luceneQueryModifier;
        this.queryRegistry = queryRegistry;
        this.applicationProperties = applicationProperties;
        this.jqlOperandResolver = jqlOperandResolver;
        this.historyPredicateQueryFactory = historyPredicateQueryFactory;
        this.emptyWasClauseOperandHandler = emptyWasClauseOperandHandler;
        this.changeHistoryFieldIdResolver = changeHistoryFieldIdResolver;
        this.changeHistoryFieldConstants = changeHistoryFieldConstants;
    }

    public boolean issueMatchesQuery(Issue issue, Iterable<Comment> comments, Iterable<ChangeHistoryItem> changeHistories, com.atlassian.query.Query query) {
        CloseableIndexDirectoryFactoryWithSearcher indexDirectoryFactory = this.createIndexDirectoryFactory();
        try {
            DefaultIssueIndexer.CommentRetriever commentRetriever = this.createCommentRetriever((List<Comment>)ImmutableList.copyOf(comments), issue);
            DefaultIssueIndexer.ChangeHistoryRetriever changeHistoryRetriever = this.createChangeHistoryRetriever((List<ChangeHistoryItem>)ImmutableList.copyOf(changeHistories), issue);
            IssueIndexer indexer = this.createIssueIndexer(indexDirectoryFactory, commentRetriever, changeHistoryRetriever);
            indexer.indexIssuesBatchMode((EnclosedIterable<Issue>)CollectionEnclosedIterable.from((Collection)ImmutableList.of((Object)issue)), Contexts.nullContext());
            IndexSearcher searcher = indexDirectoryFactory.getSearcher();
            LuceneQueryBuilder queryBuilder = this.createQueryBuilder(indexDirectoryFactory.getSearcher());
            QueryCreationContextImpl queryCreationContext = new QueryCreationContextImpl(null, true);
            Clause whereClause = query.getWhereClause();
            Query luceneQuery = queryBuilder.createLuceneQuery((QueryCreationContext)queryCreationContext, whereClause);
            TopDocs searchResult = searcher.search(luceneQuery, 1);
            boolean bl = searchResult.totalHits > 0;
            return bl;
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            indexDirectoryFactory.close();
        }
    }

    CloseableIndexDirectoryFactoryWithSearcher createIndexDirectoryFactory() {
        return new RAMIndexDirectoryFactory();
    }

    IssueIndexer createIssueIndexer(IndexDirectoryFactory indexDirectoryFactory, DefaultIssueIndexer.CommentRetriever commentRetriever, DefaultIssueIndexer.ChangeHistoryRetriever changeHistoryRetriever) {
        return new DefaultIssueIndexer(indexDirectoryFactory, commentRetriever, changeHistoryRetriever, this.applicationProperties);
    }

    DefaultIssueIndexer.ChangeHistoryRetriever createChangeHistoryRetriever(List<ChangeHistoryItem> changeHistories, final Issue issue) {
        ImmutableListMultimap grouppedChangeHiostories = Multimaps.index(changeHistories, (Function)new Function<ChangeHistoryItem, Long>(){

            public Long apply(ChangeHistoryItem changeHistoryItem) {
                return changeHistoryItem.getChangeGroupId();
            }
        });
        Collection changeHistoryGroups = Collections2.transform(grouppedChangeHiostories.asMap().entrySet(), (Function)new Function<Map.Entry<Long, Collection<ChangeHistoryItem>>, ChangeHistoryGroup>(){

            public ChangeHistoryGroup apply(Map.Entry<Long, Collection<ChangeHistoryItem>> input) {
                ChangeHistoryItem it = input.getValue().iterator().next();
                return new ChangeHistoryGroup(it.getChangeGroupId(), it.getProjectId(), it.getIssueId(), it.getIssueKey(), it.getUser(), (List)ImmutableList.copyOf(input.getValue()), it.getCreated());
            }
        });
        ImmutableList changeGroups = ImmutableList.copyOf((Collection)changeHistoryGroups);
        return new DefaultIssueIndexer.ChangeHistoryRetriever((List)changeGroups){
            final /* synthetic */ List val$changeGroups;
            {
                this.val$changeGroups = list;
            }

            public List<ChangeHistoryGroup> get(Issue input) {
                if (!issue.equals(input)) {
                    throw new IllegalArgumentException("Usupported issue was passed as argument");
                }
                return this.val$changeGroups;
            }
        };
    }

    private DefaultIssueIndexer.CommentRetriever createCommentRetriever(final List<Comment> comments, final Issue issue) {
        return new DefaultIssueIndexer.CommentRetriever(){

            public List<Comment> get(Issue input) {
                if (!issue.equals(input)) {
                    throw new IllegalArgumentException("Usupported issue was passed as argument");
                }
                return comments;
            }
        };
    }

    LuceneQueryBuilder createQueryBuilder(final IndexSearcher indexSearcher) {
        SearchProviderFactory searchProviderFactory = new SearchProviderFactory(){

            public IndexSearcher getSearcher(String searcherName) {
                return indexSearcher;
            }
        };
        WasClauseQueryFactory wasClauseQueryFactory = new WasClauseQueryFactory(searchProviderFactory, this.jqlOperandResolver, this.historyPredicateQueryFactory, this.emptyWasClauseOperandHandler, this.changeHistoryFieldIdResolver);
        ChangedClauseQueryFactory changedClauseQueryFactory = new ChangedClauseQueryFactory(searchProviderFactory, this.historyPredicateQueryFactory, this.changeHistoryFieldConstants);
        return new DefaultLuceneQueryBuilder(this.queryRegistry, this.luceneQueryModifier, wasClauseQueryFactory, changedClauseQueryFactory);
    }

    static class RAMIndexDirectoryFactory
    implements CloseableIndexDirectoryFactoryWithSearcher {
        private final Index.Manager simpleIndexManager;

        public RAMIndexDirectoryFactory() {
            RAMDirectory directory = new RAMDirectory();
            this.simpleIndexManager = Indexes.createSimpleIndexManager(new DefaultConfiguration((Directory)directory, IssueIndexer.Analyzers.INDEXING));
        }

        @Override
        public String getIndexRootPath() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public List<String> getIndexPaths() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void setIndexingMode(@NotNull IndexDirectoryFactory.Mode mode) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Map<IndexDirectoryFactory.Name, Index.Manager> get() {
            EnumMap indexes = Maps.newEnumMap(IndexDirectoryFactory.Name.class);
            for (IndexDirectoryFactory.Name type : IndexDirectoryFactory.Name.values()) {
                indexes.put(type, this.simpleIndexManager);
            }
            return Collections.unmodifiableMap(indexes);
        }

        @Override
        public void close() {
            this.simpleIndexManager.close();
        }

        @Override
        public IndexSearcher getSearcher() {
            this.simpleIndexManager.close();
            return this.simpleIndexManager.getSearcher();
        }
    }

    static interface CloseableIndexDirectoryFactoryWithSearcher
    extends IndexDirectoryFactory {
        public IndexSearcher getSearcher();

        public void close();
    }
}

