/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.jira.jelly.IssueContextAccessor;
import com.atlassian.jira.jelly.IssueContextAccessorImpl;
import com.atlassian.jira.jelly.tag.IssueAwareActionTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class AssignIssue
extends IssueAwareActionTagSupport
implements IssueContextAccessor {
    private static final transient Logger log = Logger.getLogger(AssignIssue.class);
    private static final String KEY_ISSUE_ID = "key";
    private static final String KEY_ISSUE_ASSIGNEE = "assignee";
    private boolean hasPreviousUsername = false;
    private String previousUsername = null;
    private final IssueContextAccessor issueContextAccessor;

    public AssignIssue() {
        this.setActionName("AssignIssue");
        this.issueContextAccessor = new IssueContextAccessorImpl((Tag)this);
    }

    @Override
    protected void preContextValidation() {
        if (this.getProperties().containsKey(KEY_ISSUE_ID)) {
            this.setIssue(this.getProperty(KEY_ISSUE_ID));
        }
        super.preContextValidation();
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        this.setProperty(KEY_ISSUE_ID, this.getIssue().getString(KEY_ISSUE_ID));
        String assignee = this.getProperty(KEY_ISSUE_ASSIGNEE);
        if (assignee != null) {
            this.setProperty(KEY_ISSUE_ASSIGNEE, assignee.toLowerCase());
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        super.endTagExecution(output);
        this.loadPreviousIssue();
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_ISSUE_ID, KEY_ISSUE_ASSIGNEE};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    @Override
    public void setIssue(Long issueId) {
        this.issueContextAccessor.setIssue(issueId);
    }

    @Override
    public void setIssue(String issueKey) {
        this.issueContextAccessor.setIssue(issueKey);
    }

    @Override
    public void setIssue(GenericValue issue) {
        this.issueContextAccessor.setIssue(issue);
    }

    @Override
    public void loadPreviousIssue() {
        this.issueContextAccessor.loadPreviousIssue();
    }
}

