/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.ProjectAware;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Tag;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ProjectContextAccessorImpl
implements ProjectContextAccessor,
ProjectAware {
    private static final Logger log = Logger.getLogger(ProjectContextAccessorImpl.class);
    private boolean hasProjectId = false;
    private Long projectId = null;
    private final Tag tag;

    public ProjectContextAccessorImpl(Tag tag) {
        this.tag = tag;
    }

    @Override
    public void setProject(Long projectId) {
        this.setPreviousProject();
        this.resetProjectContext();
        this.setProjectContext(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.setPreviousProject();
        this.resetProjectContext();
        this.setProjectContext(projectKey);
    }

    @Override
    public void setProject(GenericValue project) {
        this.setPreviousProject();
        this.resetProjectContext();
        this.setProjectContext(project);
    }

    @Override
    public void loadPreviousProject() {
        if (this.hasProjectId) {
            this.resetProjectContext();
            this.setProjectContext(this.projectId);
            this.hasProjectId = false;
            this.projectId = null;
        }
    }

    private void setPreviousProject() {
        if (this.hasProject()) {
            this.hasProjectId = true;
            this.projectId = this.getProjectId();
        }
    }

    private void resetProjectContext() {
        this.getContext().removeVariable("jelly.project.id");
        this.getContext().removeVariable("jelly.project.key");
    }

    private void setProjectContext(Long projectId) {
        GenericValue project = ManagerFactory.getProjectManager().getProject(projectId);
        this.setProjectContext(project);
    }

    private void setProjectContext(String projectKey) {
        GenericValue project = ManagerFactory.getProjectManager().getProjectByKey(projectKey);
        this.setProjectContext(project);
    }

    private void setProjectContext(GenericValue project) {
        if (project != null) {
            this.getContext().setVariable("jelly.project.id", (Object)project.getLong("id"));
            this.getContext().setVariable("jelly.project.key", (Object)project.getString("key"));
        }
    }

    @Override
    public JellyContext getContext() {
        return this.tag.getContext();
    }

    @Override
    public boolean hasProject() {
        return this.getContext().getVariables().containsKey("jelly.project.id");
    }

    @Override
    public Long getProjectId() {
        if (this.hasProject()) {
            return (Long)this.getContext().getVariable("jelly.project.id");
        }
        return null;
    }

    @Override
    public GenericValue getProject() {
        return ManagerFactory.getProjectManager().getProject(this.getProjectId());
    }
}

