/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.search.searchers.util.UserSearcherHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.GroupNameComparator;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class UserSearcherHelperImpl
implements UserSearcherHelper {
    private final GroupManager groupManager;
    private final PermissionManager permissionManager;
    private final UserUtil userUtil;
    private final UserHistoryManager userHistoryManager;

    public UserSearcherHelperImpl(GroupManager groupManager, PermissionManager permissionManager, UserUtil userUtil, UserHistoryManager userHistoryManager) {
        this.groupManager = groupManager;
        this.permissionManager = permissionManager;
        this.userUtil = userUtil;
        this.userHistoryManager = userHistoryManager;
    }

    public void addUserSuggestionParams(User user, List<String> selectedUsers, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        params.put("suggestedUsers", this.getSuggestedUsers(user, selectedUsers));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_user"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_user"));
        }
    }

    public void addUserGroupSuggestionParams(User user, List<String> selectedUsers, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        params.put("suggestedUsers", this.getSuggestedUsers(user, selectedUsers));
        params.put("suggestedGroups", this.getSuggestedGroups(user));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_usergroup"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_usergroup"));
        }
    }

    public void addGroupSuggestionParams(User user, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        params.put("suggestedGroups", this.getSuggestedGroups(user));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_group"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_group"));
        }
    }

    public List<Group> getSuggestedGroups(User user) {
        ArrayList groups = new ArrayList();
        if (user != null) {
            groups.addAll(this.groupManager.getGroupsForUser(user));
        } else if (this.permissionManager.hasPermission(27, user)) {
            groups.addAll(this.groupManager.getAllGroups());
        } else {
            return null;
        }
        Collections.sort(groups, new GroupNameComparator());
        return groups.subList(0, Math.min(5, groups.size()));
    }

    public List<User> getSuggestedUsers(User user, List<String> selectedUserNames) {
        if (this.permissionManager.hasPermission(27, user)) {
            int limit = 5;
            LinkedHashSet<User> suggestedUsers = new LinkedHashSet<User>();
            this.addToSuggestList(limit, suggestedUsers, this.getRecentlyUsedUsers(user), selectedUserNames);
            if (suggestedUsers.size() < limit && this.userUtil.getActiveUserCount() <= 10) {
                ArrayList<User> allUsers = new ArrayList<User>(this.userUtil.getUsers());
                Collections.sort(allUsers, new UserBestNameComparator());
                this.addToSuggestList(limit, suggestedUsers, allUsers, selectedUserNames);
            }
            return Lists.newArrayList(suggestedUsers);
        }
        return null;
    }

    private void addToSuggestList(int limit, LinkedHashSet<User> suggestedUsers, Iterable<User> users, List<String> alreadySelected) {
        for (User user : users) {
            if (suggestedUsers.size() >= limit) break;
            if (suggestedUsers.contains(user) || alreadySelected.contains(user.getName())) continue;
            suggestedUsers.add(user);
        }
    }

    private Iterable<User> getRecentlyUsedUsers(User user) {
        Function<String, User> toUser = new Function<String, User>(){

            public User apply(@Nullable String input) {
                return input == null ? null : UserSearcherHelperImpl.this.userUtil.getUser(input);
            }
        };
        Function historyItemToUser = Functions.compose((Function)toUser, (Function)UserHistoryItem.GET_ENTITY_ID);
        return new LinkedHashSet<User>(Collections2.filter((Collection)Lists.transform((List)this.userHistoryManager.getHistory(UserHistoryItem.USED_USER, user), (Function)historyItemToUser), (Predicate)Predicates.notNull()));
    }

    public boolean hasUserPickingPermission(User user) {
        int permissionId = Permissions.getType((String)"pickusers");
        return this.permissionManager.hasPermission(permissionId, user);
    }

    private I18nHelper getI18n(User user) {
        return ((I18nHelper.BeanFactory)ComponentAccessor.getComponent(I18nHelper.BeanFactory.class)).getInstance(user);
    }
}

