/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenTabImpl;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class FieldScreenImpl
extends AbstractGVBean
implements FieldScreen {
    private static final CollectionReorderer<FieldScreenTab> collectionReorderer = new CollectionReorderer();
    private final FieldScreenManager fieldScreenManager;
    private List<FieldScreenTab> tabs;
    private String description;
    private String name;
    private Long id;

    public FieldScreenImpl(FieldScreenManager fieldScreenManager) {
        this(fieldScreenManager, null);
    }

    public FieldScreenImpl(FieldScreenManager fieldScreenManager, GenericValue genericValue) {
        this.fieldScreenManager = fieldScreenManager;
        this.tabs = null;
        this.setGenericValue(genericValue);
    }

    public FieldScreenImpl deepCopy() {
        return new FieldScreenImpl(this.fieldScreenManager, this.getGenericValue());
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            this.description = this.getGenericValue().getString("description");
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        if (this.getGenericValue() != null) {
            throw new IllegalStateException("Cannot change id of an existing entity.");
        }
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateGV("description", description);
    }

    public List<FieldScreenTab> getTabs() {
        return Collections.unmodifiableList(this.getInternalTabs());
    }

    private List<FieldScreenTab> getInternalTabs() {
        if (this.tabs == null) {
            this.tabs = this.fieldScreenManager.getFieldScreenTabs((FieldScreen)this);
        }
        return this.tabs;
    }

    public FieldScreenTab getTab(int tabPosition) {
        return this.getInternalTabs().get(tabPosition);
    }

    public FieldScreenTab addTab(String tabName) {
        FieldScreenTabImpl tab = new FieldScreenTabImpl(this.fieldScreenManager);
        tab.setName(tabName);
        tab.setPosition(this.getInternalTabs().size());
        tab.setFieldScreen(this);
        this.getInternalTabs().add(tab);
        this.resequence();
        this.store();
        return tab;
    }

    public void removeTab(int tabPosition) {
        FieldScreenTab fieldScreenTab = this.getInternalTabs().remove(tabPosition);
        if (fieldScreenTab != null) {
            fieldScreenTab.setFieldScreen(null);
            fieldScreenTab.remove();
            this.resequence();
            this.store();
        }
    }

    public void moveFieldScreenTabToPosition(int tabPosition, int newPosition) {
        collectionReorderer.moveToPosition(this.getInternalTabs(), tabPosition, newPosition);
        this.resequence();
    }

    public void moveFieldScreenTabLeft(int tabPosition) {
        collectionReorderer.increasePosition(this.getInternalTabs(), this.getInternalTabs().get(tabPosition));
        this.resequence();
    }

    public void moveFieldScreenTabRight(int tabPosition) {
        collectionReorderer.decreasePosition(this.getInternalTabs(), this.getInternalTabs().get(tabPosition));
        this.resequence();
    }

    public void resequence() {
        for (int i = 0; i < this.getInternalTabs().size(); ++i) {
            FieldScreenTab fieldScreenTab = this.getInternalTabs().get(i);
            fieldScreenTab.setPosition(i);
        }
    }

    public boolean containsField(String fieldId) {
        return this.getFieldScreenLayoutItem(fieldId) != null;
    }

    public void removeFieldScreenLayoutItem(String fieldId) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.getFieldScreenLayoutItem(fieldId);
        if (fieldScreenLayoutItem == null) {
            throw new IllegalArgumentException("Cannot find field screen layout item for field with id '" + fieldId + "'.");
        }
        fieldScreenLayoutItem.getFieldScreenTab().removeFieldScreenLayoutItem(fieldScreenLayoutItem.getPosition());
    }

    private FieldScreenLayoutItem getFieldScreenLayoutItem(String fieldId) {
        for (FieldScreenTab fieldScreenTab : this.getInternalTabs()) {
            FieldScreenLayoutItem fieldScreenLayoutItem = fieldScreenTab.getFieldScreenLayoutItem(fieldId);
            if (fieldScreenLayoutItem == null) continue;
            return fieldScreenLayoutItem;
        }
        return null;
    }

    public void store() {
        if (this.isModified()) {
            if (this.getGenericValue() == null) {
                this.fieldScreenManager.createFieldScreen((FieldScreen)this);
            } else {
                this.fieldScreenManager.updateFieldScreen((FieldScreen)this);
                this.setModified(false);
            }
        }
        if (this.tabs != null) {
            for (FieldScreenTab fieldScreenTab : this.getInternalTabs()) {
                fieldScreenTab.store();
            }
        }
    }

    public void remove() {
        for (FieldScreenTab fieldScreenTab : this.getInternalTabs()) {
            this.fieldScreenManager.removeFieldScreenLayoutItems(fieldScreenTab);
        }
        this.fieldScreenManager.removeFieldScreenTabs((FieldScreen)this);
        this.fieldScreenManager.removeFieldScreen(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenImpl)) {
            return false;
        }
        FieldScreen fieldScreen = (FieldScreen)o;
        if (this.description != null ? !this.description.equals(fieldScreen.getDescription()) : fieldScreen.getDescription() != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(fieldScreen.getId()) : fieldScreen.getId() != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(fieldScreen.getName()) : fieldScreen.getName() != null);
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[FieldScreenImpl " + this.getName() + "]";
    }
}

