/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.block.LineWalker;
import com.atlassian.renderer.v2.components.table.TableBlockRenderer;
import com.atlassian.renderer.v2.components.table.TableRow;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JiraTableBlockRenderer
extends TableBlockRenderer {
    private static final Pattern START_TABLE_LINE_PATTERN = Pattern.compile("\\s*\\|.*");
    private static final Pattern END_TABLE_LINE_PATTERN = Pattern.compile(".*\\|\\s*");

    public String renderNextBlock(String thisLine, LineWalker nextLines, RenderContext context, SubRenderer subRenderer) {
        if (!context.getRenderMode().renderTables()) {
            return null;
        }
        String line = thisLine;
        Matcher matcher = START_TABLE_LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        Table table = new Table();
        ArrayList<String> potentialLines = new ArrayList<String>();
        if (END_TABLE_LINE_PATTERN.matcher(line).matches()) {
            table.addRow(this.prerenderLinks(subRenderer, line, context));
        } else {
            potentialLines.add(this.prerenderLinks(subRenderer, line, context));
        }
        while (nextLines.hasNext()) {
            line = nextLines.next();
            if (RenderUtils.isBlank((String)line) || potentialLines.isEmpty() && !START_TABLE_LINE_PATTERN.matcher(line).matches()) {
                nextLines.pushBack(line);
                break;
            }
            if (START_TABLE_LINE_PATTERN.matcher(line).matches() && !potentialLines.isEmpty()) {
                this.addNextRow(table, potentialLines);
            }
            potentialLines.add(this.prerenderLinks(subRenderer, line, context));
            if (!END_TABLE_LINE_PATTERN.matcher(line).matches()) continue;
            this.addNextRow(table, potentialLines);
        }
        if (!potentialLines.isEmpty()) {
            table.addRow(TextUtils.join((String)"\n", potentialLines));
        }
        StringBuffer buffer = new StringBuffer();
        table.render(subRenderer, context, buffer);
        return buffer.toString();
    }

    private String prerenderLinks(SubRenderer subRenderer, String line, RenderContext context) {
        return subRenderer.render(line, context, context.getRenderMode().and(RenderMode.allow((long)8236L)));
    }

    private void addNextRow(Table table, ArrayList potentialLines) {
        table.addRow(TextUtils.join((String)"\n", (Collection)potentialLines));
        potentialLines.clear();
    }

    static class Table
    extends com.atlassian.renderer.v2.components.table.Table {
        private final List<TableRow> rows = new LinkedList<TableRow>();

        Table() {
        }

        public void addRow(TableRow row) {
            this.rows.add(row);
            super.addRow(row);
        }

        public void render(SubRenderer subRenderer, RenderContext context, StringBuffer buff) {
            buff.append("<table class='confluenceTable'><tbody>\n");
            for (TableRow tableRow : this.rows) {
                tableRow.render(subRenderer, context, buff);
            }
            buff.append("</tbody></table>\n");
        }
    }
}

