/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.renderer.RendererConfiguration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

public class JiraRendererConfiguration
implements RendererConfiguration {
    private ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public JiraRendererConfiguration(ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.applicationProperties = applicationProperties;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public String getWebAppContextPath() {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getContextPath();
        }
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        if (StringUtils.isWhitespace((String)baseUrl)) {
            baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        }
        return StringUtils.isBlank((String)baseUrl) ? this.applicationProperties.getString("jira.baseurl") : baseUrl;
    }

    public boolean isNofollowExternalLinks() {
        return true;
    }

    public boolean isAllowCamelCase() {
        return false;
    }

    public String getCharacterEncoding() {
        return this.applicationProperties.getEncoding();
    }

    private HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        try {
            request = ServletActionContext.getRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return request;
    }
}

