/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueImpl;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItem;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.util.SearchContextRenderHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import webwork.action.Action;

public class MultiSelectCustomFieldSearchRenderer
extends CustomFieldRenderer {
    private final Function<String, Option> GET_OPTION_FROM_ID = new Function<String, Option>(){

        public Option apply(@Nullable String input) {
            return MultiSelectCustomFieldSearchRenderer.this.jqlSelectOptionsUtil.getOptionById(Long.parseLong(input));
        }
    };
    static final Comparator<Option> OPTION_VALUE_COMPARATOR = new Comparator<Option>(){

        @Override
        public int compare(Option a, Option b) {
            if (null == a && null == b) {
                return 0;
            }
            if (null == a) {
                return 1;
            }
            if (null == b) {
                return -1;
            }
            String aValue = a.getValue();
            String bValue = b.getValue();
            if (null == aValue && null == bValue) {
                return 0;
            }
            if (null == aValue) {
                return 1;
            }
            if (null == bValue) {
                return -1;
            }
            return aValue.compareToIgnoreCase(bValue);
        }
    };
    private final CustomField customField;
    private final CustomFieldValueProvider customFieldValueProvider;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;

    public MultiSelectCustomFieldSearchRenderer(ClauseNames clauseNames, CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor, CustomField customField, CustomFieldValueProvider customFieldValueProvider, FieldVisibilityManager fieldVisibilityManager, JqlSelectOptionsUtil jqlSelectOptionsUtil) {
        super(clauseNames, customFieldSearcherModuleDescriptor, customField, customFieldValueProvider, fieldVisibilityManager);
        this.customField = customField;
        this.customFieldValueProvider = customFieldValueProvider;
        this.jqlSelectOptionsUtil = jqlSelectOptionsUtil;
    }

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("fieldkey", this.customField.getCustomFieldType().getKey());
        Collection<Option> invalidOptions = this.getInvalidOptions(fieldValuesHolder, searchContext);
        velocityParams.put("invalidOptions", invalidOptions);
        ArrayList<Option> allOptions = new ArrayList<Option>(invalidOptions);
        allOptions.addAll(this.getValidOptions(searchContext));
        Collections.sort(allOptions, OPTION_VALUE_COMPARATOR);
        velocityParams.put("allOptions", allOptions);
        SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParams);
        return this.getEditHtml(searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("fieldkey", this.customField.getCustomFieldType().getKey());
        velocityParams.put("invalidOptions", this.getInvalidOptions(fieldValuesHolder, searchContext));
        ArrayList<Option> selectedOptions = new ArrayList<Option>(this.getSelectedOptions(fieldValuesHolder));
        Collections.sort(selectedOptions, OPTION_VALUE_COMPARATOR);
        velocityParams.put("selectedOptions", selectedOptions);
        SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParams);
        return super.getViewHtml(searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    private Collection<Option> getInvalidOptions(FieldValuesHolder fieldValuesHolder, SearchContext searchContext) {
        Set<Option> selectedOptions = this.getSelectedOptions(fieldValuesHolder);
        selectedOptions.removeAll(this.getValidOptions(searchContext));
        return selectedOptions;
    }

    private Set<Option> getSelectedOptions(FieldValuesHolder fieldValuesHolder) {
        Collection selectedOptionIds = (Collection)this.customFieldValueProvider.getStringValue(this.customField, fieldValuesHolder);
        if (selectedOptionIds != null && !selectedOptionIds.isEmpty()) {
            return new HashSet<Option>(Collections2.transform((Collection)selectedOptionIds, this.GET_OPTION_FROM_ID));
        }
        return new HashSet<Option>();
    }

    private Set<Option> getValidOptions(SearchContext searchContext) {
        FieldConfig fieldConfig = this.customField.getReleventConfig(searchContext);
        if (fieldConfig != null) {
            List configItems;
            MutableIssue issue = null;
            if (searchContext.isSingleProjectContext()) {
                issue = IssueImpl.getIssueObject(null);
                issue.setProjectObject(searchContext.getSingleProject());
            }
            if ((configItems = fieldConfig.getConfigItems()) != null && !configItems.isEmpty()) {
                for (FieldConfigItem configItem : configItems) {
                    Options options;
                    if (!configItem.getObjectKey().equals("options") || (options = (Options)configItem.getConfigurationObject((Issue)issue)) == null) continue;
                    return new HashSet<Option>((Collection<Option>)options);
                }
            }
        }
        return new HashSet<Option>();
    }
}

