/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.ssl;

import com.atlassian.jira.configurator.ssl.CertificateDetails;
import com.atlassian.jira.configurator.ssl.KeyStoreAccessor;
import com.atlassian.jira.configurator.ssl.KeyStoreProvider;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;

public class KeyStoreAccessorImpl
implements KeyStoreAccessor {
    private final KeyStoreProvider keyStoreProvider;

    public KeyStoreAccessorImpl(@Nonnull KeyStoreProvider keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    @Override
    public X509Certificate loadCertificate(@Nonnull CertificateDetails certificateDetails) throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = this.keyStoreProvider.load(certificateDetails);
        try {
            Certificate certificate;
            String keyStorePassword = certificateDetails.getKeyStorePassword();
            String keyAlias = certificateDetails.getKeyAlias();
            Key key = keyStore.getKey(keyAlias, keyStorePassword.toCharArray());
            if (key != null && (certificate = keyStore.getCertificate(keyAlias)) instanceof X509Certificate) {
                return (X509Certificate)certificate;
            }
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }
}

