/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.table;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.issue.table.IssueTableCreator;
import com.atlassian.jira.bc.issue.table.IssueTableService;
import com.atlassian.jira.bc.issue.table.IssueTableServiceConfiguration;
import com.atlassian.jira.bc.issue.table.IssueTableServiceOutcome;
import com.atlassian.jira.bc.issue.table.StableSearchResult;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.issue.table.IssueTable;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssuePager;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.component.TableLayoutUtils;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;

@Deprecated
public class DefaultIssueTableService
implements IssueTableService {
    private static final Logger log = Logger.getLogger(DefaultIssueTableService.class);
    private final SearchService searchService;
    private final SearchSortUtil searchSortUtil;
    private final JiraAuthenticationContext authenticationContext;
    private final ColumnLayoutManager columnLayoutManager;
    private final TableLayoutUtils tableLayoutUtils;
    private final JqlStringSupport jqlStringSupport;
    private final SearchProvider searchProvider;
    private final FieldManager fieldManager;
    private final ApplicationProperties applicationProperties;
    private final SearchRequestService searchRequestService;
    private final SearchHandlerManager searchHandlerManager;
    private final SearchProviderFactory searchProviderFactory;
    private final IssueFactory issueFactory;
    private static final String COLUMN_NAMES = "columnNames";
    private static final String NUM_FIELD = "num";
    private static final String JQL_PREFIX = "jql-";
    private static final String FILTER_ID = "filterId";
    private static final String FILTER_PREFIX = "filter-";
    private static final int MAX_JQL_ERRORS = 10;

    public DefaultIssueTableService(SearchService searchService, SearchSortUtil searchSortUtil, JiraAuthenticationContext authenticationContext, ColumnLayoutManager columnLayoutManager, TableLayoutUtils tableLayoutUtils, JqlStringSupport jqlStringSupport, SearchProvider searchProvider, FieldManager fieldManager, ApplicationProperties applicationProperties, SearchRequestService searchRequestService, SearchHandlerManager searchHandlerManager, SearchProviderFactory searchProviderFactory, IssueFactory issueFactory) {
        this.searchService = searchService;
        this.searchSortUtil = searchSortUtil;
        this.authenticationContext = authenticationContext;
        this.columnLayoutManager = columnLayoutManager;
        this.tableLayoutUtils = tableLayoutUtils;
        this.jqlStringSupport = jqlStringSupport;
        this.searchProvider = searchProvider;
        this.fieldManager = fieldManager;
        this.applicationProperties = applicationProperties;
        this.searchRequestService = searchRequestService;
        this.searchHandlerManager = searchHandlerManager;
        this.searchProviderFactory = searchProviderFactory;
        this.issueFactory = issueFactory;
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilterWithJql(String filterId, String jql) {
        return this.getIssueTableFromFilterWithJql(filterId, jql, new IssueTableServiceConfiguration());
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilterWithJql(String filterId, String jql, IssueTableServiceConfiguration configuration) {
        return this.getIssueTableFromFilterWithJql(filterId, jql, configuration, false);
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromJQL(String jql) {
        return this.getIssueTableFromJQL(jql, new IssueTableServiceConfiguration());
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromJQL(String jql, IssueTableServiceConfiguration configuration) {
        return this.getIssueTableFromJQL(jql, configuration, false);
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilter(String filterId) {
        return this.getIssueTableFromFilter(filterId, new IssueTableServiceConfiguration());
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilter(String filterId, IssueTableServiceConfiguration configuration) {
        return this.getIssueTableFromFilter(filterId, configuration, false);
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilterWithJql(String filterId, String jql, IssueTableServiceConfiguration configuration, boolean returnMatchingIssueIds) {
        User user = this.authenticationContext.getLoggedInUser();
        if (null == filterId) {
            return this.getIssueTableFromJQL(jql, configuration, returnMatchingIssueIds);
        }
        if (null == jql) {
            return this.getIssueTableFromFilter(filterId, configuration, returnMatchingIssueIds);
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(filterId, (ErrorCollection)errorCollection);
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            return this.buildJQLErrorServiceOutcome(parseResult.getErrors());
        }
        Query query = parseResult.getQuery();
        return this.getIssueTable(query, user, configuration, searchRequest, returnMatchingIssueIds);
    }

    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromIssueIds(List<Long> ids, final IssueTableServiceConfiguration configuration) {
        final User user = this.authenticationContext.getLoggedInUser();
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.where().issue().in(new Operand[]{new MultiValueOperand(ids)});
        final Query query = this.addOrderByToSearchRequest(queryBuilder.buildQuery(), configuration.getSortBy());
        SearchRequest searchRequest = new SearchRequest(query);
        List<ColumnLayoutItem> columns = this.getColumns(configuration, searchRequest);
        final IssueTableLayoutBean layout = this.createLayout(query, columns, configuration.isEnableSorting(), configuration.isDisplayHeader(), configuration.isShowActions());
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        final PagerFilter pagerFilter = new PagerFilter(this.getStableSearchResultsLimit());
        pagerFilter.setStart(0);
        return this.createIssueTableFromCreator(new IssueTableCreator(){

            @Override
            public IssueTable create() throws SearchException {
                SearchResults results = DefaultIssueTableService.this.searchProvider.search(query, user, pagerFilter);
                boolean jiraHasIssues = true;
                if (results.getTotal() == 0) {
                    jiraHasIssues = DefaultIssueTableService.this.searchProvider.searchCountOverrideSecurity((Query)new QueryImpl(), user) > 0L;
                }
                return DefaultIssueTableService.this.createIssueTable(results, layout, configuration.isPaging(), configuration.getNumberToShow(), null, jiraHasIssues, null);
            }
        });
    }

    ServiceOutcome<IssueTableServiceOutcome> createIssueTableFromCreator(IssueTableCreator creator) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            MessageSet validationResult = creator.validate();
            if (validationResult.hasAnyErrors()) {
                return this.buildJQLErrorServiceOutcome(validationResult);
            }
            IssueTable issueTable = creator.create();
            Set warnings = validationResult.getWarningMessages();
            return new ServiceOutcomeImpl<IssueTableServiceOutcome>((ErrorCollection)errorCollection, new IssueTableServiceOutcome(issueTable, (Collection)warnings));
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                String message = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.admin");
                errorCollection.addErrorMessage(message);
            } else {
                log.error((Object)e);
                String message = this.authenticationContext.getI18nHelper().getText("unknown.search.error");
                errorCollection.addErrorMessage(message);
            }
        }
        catch (SearchException e) {
            log.error((Object)e);
            String message = this.authenticationContext.getI18nHelper().getText("unknown.search.error");
            errorCollection.addErrorMessage(message);
        }
        return new ServiceOutcomeImpl<IssueTableServiceOutcome>((ErrorCollection)errorCollection);
    }

    ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromJQL(String jql, IssueTableServiceConfiguration configuration, boolean returnMatchingIssueIds) {
        User user = this.authenticationContext.getLoggedInUser();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            return this.buildJQLErrorServiceOutcome(parseResult.getErrors());
        }
        SearchRequest searchRequest = new SearchRequest(parseResult.getQuery());
        return this.getIssueTable(parseResult.getQuery(), user, configuration, searchRequest, returnMatchingIssueIds);
    }

    ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilter(String filterId, IssueTableServiceConfiguration configuration, boolean returnMatchingIssueIds) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(filterId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return new ServiceOutcomeImpl<IssueTableServiceOutcome>((ErrorCollection)errorCollection);
        }
        User user = this.authenticationContext.getLoggedInUser();
        return this.getIssueTable(searchRequest.getQuery(), user, configuration, searchRequest, returnMatchingIssueIds);
    }

    private ServiceOutcome<IssueTableServiceOutcome> buildJQLErrorServiceOutcome(MessageSet messageSet) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Iterable errorMessages = Iterables.limit((Iterable)messageSet.getErrorMessages(), (int)10);
        for (String error : errorMessages) {
            errors.addErrorMessage(error);
        }
        if (!errors.hasAnyErrors()) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("jql.parse.unknown.no.pos"));
        }
        return new ServiceOutcomeImpl<IssueTableServiceOutcome>((ErrorCollection)errors);
    }

    private ServiceOutcome<IssueTableServiceOutcome> getIssueTable(final Query query, final User user, final IssueTableServiceConfiguration configuration, SearchRequest searchRequest, final boolean returnMatchingIssueIds) {
        PagerFilter pagerFilter;
        if (searchRequest == null) {
            searchRequest = new SearchRequest(query);
        }
        final Query queryWithOrderBy = this.addOrderByToSearchRequest(query, configuration.getSortBy());
        List<ColumnLayoutItem> columns = this.getColumns(configuration, searchRequest);
        final Map<String, String> columnSortJql = this.generateColumnSortJql(queryWithOrderBy, columns);
        final IssueTableLayoutBean layout = this.createLayout(queryWithOrderBy, columns, configuration.isEnableSorting(), configuration.isDisplayHeader(), configuration.isShowActions());
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        final int validatedNumberToShow = this.validateNumberToShow(NUM_FIELD, configuration.getNumberToShow(), (ErrorCollection)errorCollection);
        if (returnMatchingIssueIds) {
            pagerFilter = new PagerFilter(-1);
            pagerFilter.setStart(0);
        } else {
            pagerFilter = new PagerFilter(validatedNumberToShow);
            pagerFilter.setStart(configuration.getStart());
        }
        final SearchRequest localRequest = searchRequest;
        return this.createIssueTableFromCreator(new IssueTableCreator(){

            @Override
            MessageSet validate() {
                boolean shouldValidate;
                boolean bl = shouldValidate = localRequest.getId() == null || !query.equals(localRequest.getQuery());
                if (shouldValidate) {
                    return DefaultIssueTableService.this.searchService.validateQuery(user, queryWithOrderBy);
                }
                return new MessageSetImpl();
            }

            @Override
            IssueTable create() throws SearchException {
                SearchResults results = null;
                List<Long> stableSearchIssueIds = null;
                if (!returnMatchingIssueIds) {
                    results = DefaultIssueTableService.this.searchProvider.search(queryWithOrderBy, user, pagerFilter);
                    int pageSize = pagerFilter.getPageSize();
                    while (pagerFilter.getStart() > 0 && pagerFilter.getStart() >= results.getTotal()) {
                        int totalResults = results.getTotal();
                        int startOfNewLastPage = Math.max(0, totalResults - 1) / pageSize * pageSize;
                        pagerFilter.setStart(startOfNewLastPage);
                        results = DefaultIssueTableService.this.searchProvider.search(queryWithOrderBy, user, pagerFilter);
                    }
                } else {
                    StableSearchResult stableSearch = DefaultIssueTableService.this.doStableSearch(validatedNumberToShow, queryWithOrderBy, user, pagerFilter, configuration);
                    stableSearchIssueIds = stableSearch.issueIds();
                    results = new SearchResults(stableSearch.firstPageOfIssues(), stableSearch.totalIssues().intValue(), validatedNumberToShow, configuration.getStart());
                }
                boolean jiraHasIssues = true;
                if (results.getTotal() == 0) {
                    jiraHasIssues = DefaultIssueTableService.this.searchProvider.searchCountOverrideSecurity((Query)new QueryImpl(), user) > 0L;
                }
                return DefaultIssueTableService.this.createIssueTable(results, layout, configuration.isPaging(), configuration.getNumberToShow(), columnSortJql, jiraHasIssues, stableSearchIssueIds);
            }
        });
    }

    @VisibleForTesting
    protected StableSearchResult doStableSearch(int numberToShow, Query query, User user, PagerFilter pagerFilter, IssueTableServiceConfiguration configuration) throws SearchException {
        IndexSearcher issuesSearcher = this.searchProviderFactory.getSearcher("issues");
        IssueDocumentAndIdCollector idCollector = new IssueDocumentAndIdCollector(issuesSearcher, numberToShow, configuration.getStart(), this.getStableSearchResultsLimit());
        this.searchProvider.searchAndSort(query, user, (Collector)idCollector, pagerFilter);
        return new StableSearchResult().issueIds(idCollector.getIssueIds()).firstPageOfIssues(this.toIssues(idCollector.getDocumentsOnFirstPage(configuration.getNumberToShow()))).totalIssues(idCollector.getTotal());
    }

    private List<Issue> toIssues(List<Document> issueDocs) {
        ArrayList issues = Lists.newArrayListWithCapacity((int)issueDocs.size());
        for (Document doc : issueDocs) {
            issues.add(this.issueFactory.getIssue(doc));
        }
        return issues;
    }

    ServiceOutcome<IssueTable> validateJql(IssueTableServiceConfiguration config) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.validateColumnNames(config.getColumnNames(), (ErrorCollection)errorCollection);
        this.validateNumberToShow(NUM_FIELD, config.getNumberToShow(), (ErrorCollection)errorCollection);
        return new ServiceOutcomeImpl<IssueTable>((ErrorCollection)errorCollection);
    }

    private Map<String, String> generateColumnSortJql(Query query, List<ColumnLayoutItem> columns) {
        HashMap<String, String> columnSortJql = new HashMap<String, String>();
        for (ColumnLayoutItem column : columns) {
            NavigableField field = column.getNavigableField();
            OrderBy orderBy = this.buildOrderBy(query.getOrderByClause(), field);
            columnSortJql.put(field.getId(), this.jqlStringSupport.generateJqlString((Query)new QueryImpl(query.getWhereClause(), orderBy, null)));
        }
        return columnSortJql;
    }

    private SearchRequest getSearchRequestAndValidate(String filterId, ErrorCollection errors) {
        User user = this.authenticationContext.getLoggedInUser();
        SearchRequest searchRequest = null;
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        if (StringUtils.isBlank((String)filterId)) {
            errors.addError(FILTER_ID, this.authenticationContext.getI18nHelper().getText("gadget.common.no.filter.id"));
        } else {
            if (filterId.startsWith(JQL_PREFIX)) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(user, filterId.substring(JQL_PREFIX.length()));
                if (parseResult.isValid()) {
                    searchRequest = new SearchRequest(parseResult.getQuery());
                } else {
                    for (String errorMessage : parseResult.getErrors().getErrorMessages()) {
                        errors.addError(FILTER_ID, this.authenticationContext.getI18nHelper().getText("gadget.common.invalid.filter.validationfailed", (Object)CollectionBuilder.newBuilder((Object[])new String[]{filterId, errorMessage}).asList()));
                    }
                }
            } else {
                searchRequest = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, this.stripFilterPrefix(filterId, FILTER_PREFIX));
            }
            if (searchRequest == null) {
                errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.filters.nonexistent"));
            }
        }
        return searchRequest;
    }

    private IssueTable createIssueTable(SearchResults results, IssueTableLayoutBean layout, boolean isPaging, int numberToShow, Map<String, String> columnSortJql, boolean jiraHasIssues, List<Long> issueIds) {
        String html = results.getIssues().isEmpty() ? null : this.getHtmlForSearchResults(results, layout, isPaging);
        String url = "";
        String name = "";
        String description = "";
        return new IssueTable.Builder(html).displayed(results.getIssues().size()).total(results.getTotal()).startIndex(results.getNiceStart()).end(results.getEnd()).page(0).pageSize(numberToShow).url("").title("").description("").columnSortJql(columnSortJql).jiraHasIssues(jiraHasIssues).issueIds(issueIds).build();
    }

    @VisibleForTesting
    protected String getHtmlForSearchResults(SearchResults results, IssueTableLayoutBean layout, boolean isPaging) {
        return new IssueTableWebComponent().getHtml(layout, results.getIssues(), (IssuePager)(isPaging ? results : null));
    }

    private IssueTableLayoutBean createLayout(Query query, List<ColumnLayoutItem> columns, boolean enableSorting, boolean displayHeader, boolean showActions) {
        OrderBy orderBy = query.getOrderByClause();
        IssueTableLayoutBean layout = new IssueTableLayoutBean(columns, (Collection)orderBy.getSearchSorts());
        layout.addCellDisplayParam("navigator_view", (Object)Boolean.TRUE);
        layout.setSortingEnabled(enableSorting);
        layout.setDisplayHeader(displayHeader);
        layout.setShowExteriorTable(false);
        layout.setShowActionColumn(showActions);
        layout.setTableCssClass("grid issuetable-db maxWidth");
        layout.setDisplayHeaderPager(false);
        return layout;
    }

    private OrderBy buildOrderBy(OrderBy orderBy, NavigableField field) {
        String columnName;
        SortOrder columnDirection = SortOrder.parseString((String)field.getDefaultSortOrder());
        boolean isCustomField = field instanceof CustomField;
        if (isCustomField) {
            CustomField customField = (CustomField)field;
            columnName = JqlCustomFieldId.toString((long)customField.getIdAsLong());
        } else {
            Collection jqlClauseNames = this.searchHandlerManager.getJqlClauseNames(field.getId());
            columnName = !jqlClauseNames.isEmpty() ? ((ClauseNames)jqlClauseNames.iterator().next()).getPrimaryName() : field.getId();
        }
        ArrayList<SearchSort> searchSorts = new ArrayList<SearchSort>();
        for (SearchSort searchSort : orderBy.getSearchSorts()) {
            ClauseInformation clauseInformation = SystemSearchConstants.getClauseInformationById((String)columnName);
            String fieldInSearch = searchSort.getField();
            if (!isCustomField && clauseInformation != null && clauseInformation.getJqlClauseNames().contains(fieldInSearch) || fieldInSearch.equals(columnName) || isCustomField && ((CustomField)field).getFieldName().equals(fieldInSearch)) {
                columnName = fieldInSearch;
                SortOrder sortOrder = searchSort.getSortOrder();
                if (sortOrder == null) {
                    sortOrder = SortOrder.parseString((String)field.getDefaultSortOrder());
                }
                if (sortOrder == SortOrder.ASC) {
                    columnDirection = SortOrder.DESC;
                    continue;
                }
                columnDirection = SortOrder.ASC;
                continue;
            }
            searchSorts.add(searchSort);
        }
        searchSorts.add(0, new SearchSort(columnName, columnDirection));
        return new OrderByImpl(searchSorts);
    }

    private List<ColumnLayoutItem> getColumns(IssueTableServiceConfiguration config, SearchRequest searchRequest) {
        User user = this.authenticationContext.getLoggedInUser();
        try {
            ColumnLayout columnLayout = searchRequest.isLoaded() && config.isUseFilterColumns() ? this.columnLayoutManager.getColumnLayout(user, searchRequest) : this.columnLayoutManager.getColumnLayout(user);
            QueryContext queryContext = this.searchService.getQueryContext(user, searchRequest.getQuery());
            return columnLayout.getVisibleColumnLayoutItems(user, queryContext);
        }
        catch (ColumnLayoutException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ColumnLayoutStorageException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    Query addOrderByToSearchRequest(Query preOrderByQuery, String sortBy) {
        if (StringUtils.isNotBlank((String)sortBy)) {
            String sortDirection = null;
            if (sortBy.endsWith(":DESC") || sortBy.endsWith(":ASC")) {
                sortDirection = sortBy.substring(sortBy.lastIndexOf(58) + 1);
                sortBy = sortBy.substring(0, sortBy.lastIndexOf(58));
            }
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)preOrderByQuery);
            String[] sortArray = new String[]{sortDirection};
            String[] fieldArray = new String[]{sortBy};
            MapBuilder builder = MapBuilder.newBuilder();
            Map params = builder.add((Object)"sorter/order", (Object)sortArray).add((Object)"sorter/field", (Object)fieldArray).toMap();
            OrderBy newOrder = this.searchSortUtil.getOrderByClause(params);
            OrderBy oldOrder = queryBuilder.orderBy().buildOrderBy();
            User user = this.authenticationContext.getLoggedInUser();
            List newSearchSorts = newOrder.getSearchSorts();
            List oldSearchSorts = oldOrder.getSearchSorts();
            List sorts = this.searchSortUtil.mergeSearchSorts(user, (Collection)newSearchSorts, (Collection)oldSearchSorts, 3);
            queryBuilder.orderBy().setSorts((Collection)sorts);
            return queryBuilder.buildQuery();
        }
        return preOrderByQuery;
    }

    private int getStableSearchResultsLimit() {
        return Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.search.stable.max.results"));
    }

    private int validateNumberToShow(String fieldName, int numberToShow, ErrorCollection errors) {
        if (numberToShow <= 0) {
            errors.addError(fieldName, this.authenticationContext.getI18nHelper().getText("gadget.common.num.negative"));
        }
        return numberToShow;
    }

    private Long stripFilterPrefix(String filterId, String prefix) {
        if (filterId.startsWith(prefix)) {
            String numPart = filterId.substring(prefix.length());
            return Long.valueOf(numPart);
        }
        return Long.valueOf(filterId);
    }

    void validateColumnNames(List<String> columnNames, ErrorCollection errors) {
        if (columnNames != null && !columnNames.isEmpty()) {
            try {
                ArrayList<String> fieldsNotFound = new ArrayList<String>();
                User user = this.authenticationContext.getLoggedInUser();
                Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
                for (String columnName : columnNames) {
                    if ("--default--".equalsIgnoreCase(columnName)) continue;
                    boolean found = false;
                    for (NavigableField availableField : availableFields) {
                        if (!columnName.equals(availableField.getId())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fieldsNotFound.add(columnName);
                }
                if (!fieldsNotFound.isEmpty()) {
                    String fieldsNotFoundString = StringUtils.join(fieldsNotFound, (String)", ");
                    errors.addError(COLUMN_NAMES, this.authenticationContext.getI18nHelper().getText("issue.table.service.invalid.columns", fieldsNotFoundString));
                }
            }
            catch (FieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class IssueDocumentAndIdCollector
    extends DocumentHitCollector {
        private int total = 0;
        private final List<Long> issueIds;
        private final List<Document> issueDocuments;
        private final int pageSize;
        private final int startIndex;
        private final int maxSize;

        public IssueDocumentAndIdCollector(IndexSearcher issuesSearcher, int pageSize, int startIndex, int maxSize) {
            super(issuesSearcher);
            this.pageSize = pageSize;
            this.startIndex = startIndex;
            this.maxSize = maxSize;
            this.issueIds = Lists.newArrayListWithCapacity((int)maxSize);
            this.issueDocuments = Lists.newArrayListWithCapacity((int)maxSize);
        }

        public void collect(Document doc) {
            if (this.total < this.maxSize) {
                this.issueIds.add(Long.valueOf(doc.get("issue_id")));
                if (this.issueIds.size() > this.startIndex && this.issueDocuments.size() < this.pageSize) {
                    this.issueDocuments.add(doc);
                }
            }
            ++this.total;
        }

        public List<Document> getDocumentsOnFirstPage(int numberToShow) {
            int max = Math.min(numberToShow, this.issueIds.size());
            if (this.issueDocuments.size() > max) {
                return this.issueDocuments.subList(0, Math.min(numberToShow, this.issueIds.size()));
            }
            return this.issueDocuments;
        }

        public List<Long> getIssueIds() {
            return this.issueIds;
        }

        public int getTotal() {
            return this.total;
        }
    }
}

