/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin;

import com.atlassian.jira.admin.ApplicationPropertiesPersister;
import com.atlassian.jira.admin.IntroductionProperty;
import com.atlassian.jira.admin.PropertyDescriptions;
import com.atlassian.jira.admin.RenderablePropertyFactory;
import com.atlassian.jira.admin.RenderablePropertyImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;

public class IntroductionPropertyImpl
implements IntroductionProperty {
    private final RenderablePropertyImpl introductionProperty;
    private final I18nHelper.BeanFactory i18nFactory;
    private final JiraAuthenticationContext authenticationContext;

    public IntroductionPropertyImpl(ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext authenticationContext, RenderablePropertyFactory renderablePropertyFactory) {
        this.i18nFactory = i18nFactory;
        this.authenticationContext = authenticationContext;
        this.introductionProperty = renderablePropertyFactory.create(new ApplicationPropertiesPersister(applicationProperties, "jira.introduction"), new IntroductionDescriptions());
    }

    @Override
    public String getValue() {
        return this.introductionProperty.getValue();
    }

    @Override
    public void setValue(String value) {
        this.introductionProperty.setValue(value);
    }

    @Override
    public String getEditHtml(String fieldName) {
        return this.introductionProperty.getEditHtml(fieldName);
    }

    @Override
    public String getViewHtml() {
        return this.introductionProperty.getViewHtml();
    }

    @Override
    public String getDescriptionHtml() {
        return this.introductionProperty.getDescriptionHtml();
    }

    private class IntroductionDescriptions
    implements PropertyDescriptions {
        private IntroductionDescriptions() {
        }

        @Override
        public String getBtfDescriptionHtml() {
            return IntroductionPropertyImpl.this.i18nFactory.getInstance(IntroductionPropertyImpl.this.authenticationContext.getLoggedInUser()).getText("admin.generalconfiguration.introduction.description", "<br/>");
        }

        @Override
        public String getOnDemandDescriptionHtml() {
            return IntroductionPropertyImpl.this.i18nFactory.getInstance(IntroductionPropertyImpl.this.authenticationContext.getLoggedInUser()).getText("admin.generalconfiguration.introduction.wiki.description", "<br/>");
        }
    }
}

