/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AbstractWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.ProjectMigrator;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationCompletedEvent;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class AbstractWorkflowSchemeSingleProjectMigrationHelper<T extends WorkflowScheme>
extends AbstractWorkflowSchemeMigrationHelper<T>
implements WorkflowSchemeMigrationHelper<T> {
    protected final Project project;
    protected final String projectName;
    final Long projectId;
    protected ProjectMigrator<T> projectMigrator;

    AbstractWorkflowSchemeSingleProjectMigrationHelper(Project project, T targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, User user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, final EventPublisher eventPublisher) throws WorkflowException, GenericEntityException {
        super(targetScheme, workflowManager, delegator, schemeManager, i18nHelper, user, constantsManager, taskManager, issueIndexManager, workflowSchemeManager, eventPublisher);
        this.project = project;
        this.projectName = project.getName();
        this.projectId = project.getId();
        this.projectMigrator = new ProjectMigrator<T>(project, targetScheme, workflowManager, schemeManager, delegator, user, constantsManager, i18nHelper, issueIndexManager, new ProjectMigrator.OnCompleteCallback<T>((WorkflowScheme)targetScheme){
            final /* synthetic */ WorkflowScheme val$targetScheme;
            {
                this.val$targetScheme = workflowScheme;
            }

            @Override
            public void onComplete(SchemeManager schemeManager, Project project, T workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
                AbstractWorkflowSchemeSingleProjectMigrationHelper.this.completeActually(schemeManager, project, workflowScheme, migrationSink);
                eventPublisher.publish((Object)new WorkflowSchemeMigrationCompletedEvent(this.val$targetScheme));
            }
        });
        this.calculateInputRequired();
    }

    @Override
    JiraWorkflow getExistingWorkflow(String issueTypeId) throws WorkflowException {
        return this.getExistingWorkflowByProjectId(issueTypeId, this.projectId);
    }

    @Override
    EntityCondition getProjectClause(String projectField) {
        return new EntityFieldMap((Map)ImmutableMap.of((Object)projectField, (Object)this.projectId), EntityOperator.AND);
    }

    @Override
    public WorkflowMigrationResult migrate(TaskProgressSink sink) throws GenericEntityException, WorkflowException {
        return this.projectMigrator.migrate(sink, this.typesNeedingMigration, this.workflowMigrationMapping);
    }

    abstract void completeActually(SchemeManager var1, Project var2, T var3, StatefulTaskProgressSink var4) throws GenericEntityException;

    @Override
    void quickMigrate() throws GenericEntityException {
        this.projectMigrator.complete(this.schemeManager, this.project, this.targetScheme, null);
    }

    @Override
    String getMigrateAsyncTaskDesc() {
        return this.i18nHelper.getText("admin.selectworkflows.task.desc", this.projectName, this.schemeName);
    }
}

