/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

abstract class AbstractWorkflowScheme
implements WorkflowScheme {
    private final Long id;
    private final Map<String, String> workflowMap;

    AbstractWorkflowScheme(Long id, Map<String, String> workflowMap) {
        this.id = id;
        this.workflowMap = Collections.unmodifiableMap(Maps.newHashMap(workflowMap));
    }

    @Nonnull
    public String getActualWorkflow(String issueTypeId) {
        String workflow = this.workflowMap.get(issueTypeId);
        if (workflow == null) {
            workflow = this.getActualDefaultWorkflow();
        }
        return workflow;
    }

    @Nonnull
    public String getActualDefaultWorkflow() {
        String workflow = this.workflowMap.get(null);
        if (workflow == null) {
            workflow = "jira";
        }
        return workflow;
    }

    public Long getId() {
        return this.id;
    }

    @Nonnull
    public Map<String, String> getMappings() {
        return this.workflowMap;
    }

    public String getConfiguredDefaultWorkflow() {
        return this.workflowMap.get(null);
    }

    public String getConfiguredWorkflow(String issueTypeId) {
        return this.workflowMap.get(issueTypeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractWorkflowScheme that = (AbstractWorkflowScheme)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

