/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.session.currentusers;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.filters.accesslog.AtlassianSessionIdUtil;
import com.atlassian.jira.web.session.JiraSessionPluginTracker;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantManager;
import com.atlassian.multitenant.Tenant;
import com.atlassian.sal.api.events.SessionDestroyedEvent;
import com.google.common.annotations.VisibleForTesting;
import java.security.Principal;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class JiraUserSessionDestroyListener
implements HttpSessionListener {
    private static final Logger loggerSecurityEvents = LoginLoggers.LOGIN_SECURITY_EVENTS;

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        if (httpSession != null) {
            loggerSecurityEvents.info((Object)("HttpSession created [" + this.encodeSessionId(httpSession.getId()) + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        if (this.getJiraSessionPluginTracker().pluginsUp() && httpSession != null) {
            if (MultiTenantContext.getManager() == null || MultiTenantContext.getManager().isSingleTenantMode() || MultiTenantContext.getTenantReference().isSet()) {
                this.destroySession(httpSession);
            } else {
                MultiTenantManager multiTenantManager = MultiTenantContext.getManager();
                Tenant tenant = multiTenantManager.getTenantFromSession(httpSession);
                MultiTenantContext.getTenantReference().set(tenant, false);
                try {
                    this.destroySession(httpSession);
                }
                finally {
                    MultiTenantContext.getTenantReference().remove();
                }
            }
        }
    }

    private void destroySession(HttpSession session) {
        this.getJiraSessionTracker().removeSession(session.getId());
        Principal principal = (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        this.getEventPublisher().publish((Object)SessionDestroyedEvent.builder().sessionId(session.getId()).userName(principal == null ? null : principal.getName()).build());
        loggerSecurityEvents.info((Object)("HttpSession [" + this.encodeSessionId(session.getId()) + "] destroyed for '" + (principal == null ? "anonymous" : principal.getName()) + "'"));
    }

    @VisibleForTesting
    JiraUserSessionTracker getJiraSessionTracker() {
        return JiraUserSessionTracker.getInstance();
    }

    @VisibleForTesting
    EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    @VisibleForTesting
    JiraSessionPluginTracker getJiraSessionPluginTracker() {
        return (JiraSessionPluginTracker)ComponentAccessor.getComponent(JiraSessionPluginTracker.class);
    }

    private String encodeSessionId(String id) {
        return AtlassianSessionIdUtil.generateASESSIONID(id);
    }
}

