/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.servlet.BufferingRequestDispatcher;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.util.OutputConverter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.exception.VelocityException;

public class VelocityDecoratorServlet
extends HttpServlet {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Page page = (Page)request.getAttribute("__sitemesh__page");
        if (page == null) {
            String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (servletPath == null) {
                servletPath = request.getServletPath();
            }
            throw new ServletException("No sitemesh page to decorate. This servlet should not be invoked directly. The path invoked was " + servletPath);
        }
        this.applyDecoratorUsingVelocity(request, page, response);
    }

    private void applyDecoratorUsingVelocity(HttpServletRequest request, Page page, HttpServletResponse response) throws IOException {
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        if (servletPath != null && servletPath.startsWith("/")) {
            servletPath = servletPath.substring(1);
        }
        Map<String, Object> velocityParams = this.getVelocityParams(request, page, response);
        PrintWriter writer = response.getWriter();
        try {
            response.setContentType(this.getApplicationProperties().getContentType());
            String body = this.getTemplatingEngine().render(TemplateSources.file((String)servletPath)).applying(velocityParams).asHtml();
            writer.write(body);
        }
        catch (VelocityException e) {
            writer.write("Exception rendering velocity file " + servletPath);
            writer.write("<br><pre>");
            e.printStackTrace(writer);
            writer.write("</pre>");
        }
        request.removeAttribute("__sitemesh__page");
    }

    private Map<String, Object> getVelocityParams(HttpServletRequest request, Page page, HttpServletResponse response) throws IOException {
        Map<String, Object> velocityParams = this.getDefaultVelocityParams();
        velocityParams.put("page", page);
        velocityParams.put("title", page.getTitle());
        StringWriter bodyBuffer = new StringWriter();
        page.writeBody(OutputConverter.getWriter((Writer)bodyBuffer));
        velocityParams.put("body", bodyBuffer);
        if (page instanceof HTMLPage) {
            HTMLPage htmlPage = (HTMLPage)page;
            StringWriter buffer = new StringWriter();
            htmlPage.writeHead(OutputConverter.getWriter((Writer)buffer));
            velocityParams.put("head", buffer.toString());
        }
        velocityParams.put("dispatcher", new BufferingRequestDispatcher(request, response));
        velocityParams.put("i18n", this.getJiraAuthenticationContext().getI18nHelper());
        velocityParams.put("req", request);
        return velocityParams;
    }

    @VisibleForTesting
    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    @VisibleForTesting
    JiraAuthenticationContext getJiraAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    @VisibleForTesting
    Map<String, Object> getDefaultVelocityParams() {
        return JiraVelocityUtils.getDefaultVelocityParams(this.getJiraAuthenticationContext());
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }
}

