/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.less.inlineimage;

import com.atlassian.jira.issue.attachment.MimetypesFileTypeMap;
import com.atlassian.jira.web.less.LessTransformer;
import com.atlassian.jira.web.less.inlineimage.InlineImage;
import com.google.common.annotations.VisibleForTesting;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class InlineImageEncoder {
    public static ThreadLocal<LessTransformer.LessResource.BaseLoader> resourceLoader = new ThreadLocal();

    public static InlineImage encode(String imagePath) {
        return InlineImageEncoder.actuallyEncode(imagePath, false);
    }

    public static InlineImage encodeOptimized(String imagePath) {
        return InlineImageEncoder.actuallyEncode(imagePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InlineImage actuallyEncode(String imagePath, boolean optimize) {
        String data;
        block6: {
            try {
                InputStream imageInputStream = InlineImageEncoder.getLoader().getResourceInputStream(imagePath);
                if (imageInputStream != null) {
                    try {
                        data = optimize ? InlineImageEncoder.encodeOptimized(imageInputStream, FilenameUtils.getExtension((String)imagePath)) : InlineImageEncoder.encode(imageInputStream);
                        break block6;
                    }
                    finally {
                        imageInputStream.close();
                    }
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new InlineImage(data, MimetypesFileTypeMap.getContentType(imagePath));
    }

    @VisibleForTesting
    static String encode(InputStream inputStream) throws IOException {
        return InlineImageEncoder.encodeBase64String(IOUtils.toByteArray((InputStream)inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static String encodeOptimized(InputStream imageInputStream, String format) throws IOException {
        BufferedImage image = ImageIO.read(imageInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] outputbyteArray = byteArrayOutputStream.toByteArray();
            String string = InlineImageEncoder.encodeBase64String(outputbyteArray);
            return string;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    private static String encodeBase64String(byte[] byteArray) {
        return new String(Base64.encodeBase64((byte[])byteArray));
    }

    public static LessTransformer.LessResource.BaseLoader getLoader() {
        return resourceLoader.get();
    }

    public static void setLoader(LessTransformer.LessResource.BaseLoader loader) {
        resourceLoader.set(loader);
    }
}

