/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class ProjectDescriptionRendererBean {
    private final ProjectDescriptionRenderer renderer;

    public ProjectDescriptionRendererBean(@Nonnull ProjectDescriptionRenderer renderer) {
        this.renderer = (ProjectDescriptionRenderer)Preconditions.checkNotNull((Object)renderer);
    }

    public ProjectDescriptionRendererBean() {
        this((ProjectDescriptionRenderer)ComponentAccessor.getComponent(ProjectDescriptionRenderer.class));
    }

    public String getViewHtml(@Nonnull GenericValue genericValue) {
        Preconditions.checkNotNull((Object)genericValue, (Object)"generic value must not be null");
        ProjectImpl project = new ProjectImpl(genericValue);
        return this.getViewHtml(project);
    }

    @Nonnull
    public String getViewHtml(@Nonnull Project project) {
        Preconditions.checkNotNull((Object)project, (Object)"project must not be null");
        return this.renderDescriptionAsHtml(project);
    }

    @Nonnull
    private String renderDescriptionAsHtml(@Nonnull Project project) {
        return Strings.nullToEmpty((String)this.renderer.getViewHtml(project));
    }
}

