/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util.workflow;

import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WorkflowEditorTransitionConditionUtil {
    public static final String SEPARATOR = ".";
    public static final String OPERATOR_AND = "AND";
    public static final String OPERATOR_OR = "OR";

    public ConditionsDescriptor getParentConditionsDescriptor(RestrictionDescriptor restrictionDescriptor, String count) {
        return this.findConfitionsDescriptor(restrictionDescriptor, count, 1);
    }

    public ConditionsDescriptor getConditionsDescriptor(RestrictionDescriptor restrictionDescriptor, String count) {
        return this.findConfitionsDescriptor(restrictionDescriptor, count, 0);
    }

    private ConditionsDescriptor findConfitionsDescriptor(RestrictionDescriptor restrictionDescriptor, String count, int offset) {
        ConditionsDescriptor conditionsDescriptor = restrictionDescriptor.getConditionsDescriptor();
        String[] counts = StringUtils.split((String)count, (String)SEPARATOR);
        if (counts != null && counts.length > offset) {
            for (int i = 0; i < counts.length - offset; ++i) {
                int c = Integer.parseInt(counts[i]);
                List conditions = conditionsDescriptor.getConditions();
                if (!(conditions.get(c - 1) instanceof ConditionsDescriptor)) {
                    throw new IllegalArgumentException("The descriptor at count " + count + " is not a ConditionsDescriptor.");
                }
                conditionsDescriptor = (ConditionsDescriptor)conditions.get(c - 1);
            }
        }
        return conditionsDescriptor;
    }

    public void getGrandParentConditionsDescriptor(RestrictionDescriptor restriction, String count) {
    }

    public boolean isEmpty(RestrictionDescriptor restrictionDescriptor) {
        ConditionsDescriptor conditionsDescriptor = restrictionDescriptor.getConditionsDescriptor();
        if (conditionsDescriptor == null) {
            return true;
        }
        List conditions = conditionsDescriptor.getConditions();
        return conditions == null || conditions.isEmpty();
    }

    public boolean isEmpty(ConditionsDescriptor conditionsDescriptor) {
        List conditions = conditionsDescriptor.getConditions();
        return conditions == null || conditions.isEmpty();
    }

    public String increaseCountLevel(String c) {
        if (c == null) {
            return null;
        }
        int index = c.lastIndexOf(SEPARATOR);
        if (index < 0) {
            throw new IllegalArgumentException("The string '" + c + "' does not contain '" + SEPARATOR + "'.");
        }
        return c.substring(0, index);
    }

    public int getLastCount(String count) {
        int index = count.lastIndexOf(SEPARATOR);
        if (index < 0) {
            return Integer.parseInt(count);
        }
        if (index + 1 >= count.length()) {
            throw new IllegalArgumentException("Cannot find last index in '" + count + "'.");
        }
        return Integer.parseInt(count.substring(index + 1));
    }

    public String addCondition(ActionDescriptor transition, String count, ConditionDescriptor condition) {
        RestrictionDescriptor restriction = this.initRestriction(transition);
        ConditionsDescriptor conditionsDescriptor = restriction.getConditionsDescriptor();
        if (conditionsDescriptor == null) {
            conditionsDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor();
            restriction.setConditionsDescriptor(conditionsDescriptor);
            conditionsDescriptor.setType(OPERATOR_AND);
            conditionsDescriptor.getConditions().add(condition);
            return "1";
        }
        conditionsDescriptor = this.getParentConditionsDescriptor(restriction, count);
        if (conditionsDescriptor.getConditions() == null) {
            conditionsDescriptor.setConditions(new ArrayList());
        }
        conditionsDescriptor.getConditions().add(condition);
        if (!TextUtils.stringSet((String)conditionsDescriptor.getType())) {
            conditionsDescriptor.setType(OPERATOR_AND);
        }
        if (this.isRootCount(count)) {
            return "" + conditionsDescriptor.getConditions().size();
        }
        return this.increaseCountLevel(count) + SEPARATOR + conditionsDescriptor.getConditions().size();
    }

    public String addNestedCondition(ActionDescriptor transition, String count, ConditionDescriptor condition) {
        RestrictionDescriptor restriction = this.initRestriction(transition);
        ConditionsDescriptor conditionsDescriptor = restriction.getConditionsDescriptor();
        if (conditionsDescriptor == null) {
            conditionsDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor();
            restriction.setConditionsDescriptor(conditionsDescriptor);
            conditionsDescriptor.setType(OPERATOR_AND);
            conditionsDescriptor.getConditions().add(condition);
            return "1";
        }
        conditionsDescriptor = this.getParentConditionsDescriptor(restriction, count);
        int index = this.getLastCount(count) - 1;
        Object d = conditionsDescriptor.getConditions().remove(index);
        if (d instanceof ConditionDescriptor) {
            ConditionDescriptor existingCondition = (ConditionDescriptor)d;
            ConditionsDescriptor nestedDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor();
            nestedDescriptor.setType(OPERATOR_AND);
            if (nestedDescriptor.getConditions() == null) {
                nestedDescriptor.setConditions(new ArrayList());
            }
            nestedDescriptor.getConditions().add(existingCondition);
            nestedDescriptor.getConditions().add(condition);
            int insertIndex = this.findNestedBlockInsertIndex(conditionsDescriptor);
            conditionsDescriptor.getConditions().add(insertIndex, nestedDescriptor);
            StringBuilder returnIndex = new StringBuilder();
            if (!this.isRootCount(count)) {
                returnIndex.append(this.increaseCountLevel(count));
                returnIndex.append(SEPARATOR);
            }
            returnIndex.append(insertIndex + 1);
            returnIndex.append(SEPARATOR);
            returnIndex.append(nestedDescriptor.getConditions().size());
            return returnIndex.toString();
        }
        throw new IllegalArgumentException("Descriptor at position '" + count + "' must be a ConditionDescriptor");
    }

    private RestrictionDescriptor initRestriction(ActionDescriptor transition) {
        RestrictionDescriptor restriction = transition.getRestriction();
        if (restriction == null) {
            restriction = new RestrictionDescriptor();
            transition.setRestriction(restriction);
        }
        return restriction;
    }

    private int findNestedBlockInsertIndex(ConditionsDescriptor conditionsDescriptor) {
        List conditions = conditionsDescriptor.getConditions();
        if (conditions == null) {
            return 0;
        }
        int i = 0;
        for (Object descriptor : conditions) {
            if (descriptor instanceof ConditionDescriptor) {
                return i;
            }
            if (descriptor instanceof ConditionsDescriptor) {
                ++i;
                continue;
            }
            throw new IllegalArgumentException("Cannot process class '" + descriptor.getClass().getName() + "'.");
        }
        return i;
    }

    public void deleteCondition(ActionDescriptor transition, String count) {
        RestrictionDescriptor restriction = transition.getRestriction();
        if (restriction != null) {
            ConditionsDescriptor conditionsDescriptor = this.getParentConditionsDescriptor(restriction, count);
            conditionsDescriptor.getConditions().remove(this.getLastCount(count) - 1);
            if (this.isEmpty(conditionsDescriptor)) {
                while (this.isEmpty(conditionsDescriptor)) {
                    if (this.isRootCount(count)) {
                        transition.setRestriction(null);
                        break;
                    }
                    count = this.increaseCountLevel(count);
                    conditionsDescriptor = this.getParentConditionsDescriptor(restriction, count);
                    conditionsDescriptor.getConditions().remove(this.getLastCount(count) - 1);
                }
            } else if (conditionsDescriptor.getConditions().size() == 1) {
                Object descriptor = conditionsDescriptor.getConditions().get(0);
                if (descriptor instanceof ConditionDescriptor) {
                    if (!this.isRootCount(count)) {
                        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
                        count = this.increaseCountLevel(count);
                        ConditionsDescriptor conditionsDescriptor2 = this.getParentConditionsDescriptor(restriction, count);
                        int index = this.getLastCount(count) - 1;
                        conditionsDescriptor2.getConditions().remove(index);
                        index = this.findNestedBlockInsertIndex(conditionsDescriptor2);
                        conditionsDescriptor2.getConditions().add(index, conditionDescriptor);
                    }
                } else if (descriptor instanceof ConditionsDescriptor) {
                    ConditionsDescriptor cd = (ConditionsDescriptor)descriptor;
                    conditionsDescriptor.getConditions().remove(0);
                    if (cd.getConditions() != null && !cd.getConditions().isEmpty()) {
                        conditionsDescriptor.getConditions().addAll(cd.getConditions());
                    }
                } else {
                    throw new IllegalArgumentException("Cannot deal with '" + descriptor.getClass().getName() + "'.");
                }
            }
        }
    }

    private boolean isRootCount(String count) {
        if (TextUtils.stringSet((String)count)) {
            return count.indexOf(SEPARATOR) < 0;
        }
        return true;
    }

    public void changeLogicOperator(ActionDescriptor transition, String count) {
        RestrictionDescriptor restriction = transition.getRestriction();
        if (restriction != null) {
            ConditionsDescriptor conditionsDescriptor = this.getParentConditionsDescriptor(restriction, count);
            if (OPERATOR_AND.equals(conditionsDescriptor.getType())) {
                conditionsDescriptor.setType(OPERATOR_OR);
            } else {
                conditionsDescriptor.setType(OPERATOR_AND);
            }
        }
    }
}

