/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import java.util.Map;
import webwork.action.Action;

public class DeleteComment
extends AbstractIssueSelectAction {
    private static final String ERROR_NO_PERMISSION = "errorNoPermission";
    private Long id;
    private FieldScreenRenderer fieldScreenRendererWithAllFields;
    private FieldScreenRendererFactory fieldScreenRendererFactory;
    private CommentService commentService;
    private Comment commentObject;

    public DeleteComment(FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService) {
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.commentService = commentService;
    }

    public String doDefault() {
        return this.commentService.hasPermissionToDelete(this.getJiraServiceContext(), this.getCommentId()) ? "input" : ERROR_NO_PERMISSION;
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        if (!this.commentService.hasPermissionToDelete(this.getJiraServiceContext(), this.getCommentId())) {
            return ERROR_NO_PERMISSION;
        }
        String issueKey = this.getIssueObject().getKey();
        this.commentService.delete(this.getJiraServiceContext(), this.getCommentObject(), true);
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.getRedirect("/browse/" + issueKey);
    }

    public void setCommentId(Long id) {
        this.id = id;
    }

    public Long getCommentId() {
        return this.id;
    }

    @Override
    public String getIssuePath() {
        return "/browse/" + this.getIssueObject().getKey();
    }

    public String getRenderedContent() {
        OrderableField field = (OrderableField)this.getField("comment");
        FieldLayoutItem fieldLayoutItem = this.getFieldScreenRendererLayoutItemForField(field).getFieldLayoutItem();
        Map value = EasyMap.build((Object)field.getId(), (Object)this.getCommentObject().getBody());
        return fieldLayoutItem.getOrderableField().getViewHtml(fieldLayoutItem, (Action)this, (Issue)this.getIssueObject(), (Object)value, null);
    }

    public FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(OrderableField field) {
        return this.getFieldScreenRendererWithAllFields().getFieldScreenRenderLayoutItem(field);
    }

    protected FieldScreenRenderer getFieldScreenRendererWithAllFields() {
        if (this.fieldScreenRendererWithAllFields == null) {
            this.fieldScreenRendererWithAllFields = this.fieldScreenRendererFactory.getFieldScreenRenderer(this.getLoggedInUser(), (Issue)this.getIssueObject(), (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, false);
        }
        return this.fieldScreenRendererWithAllFields;
    }

    public Comment getCommentObject() {
        if (this.commentObject == null) {
            this.commentObject = this.commentService.getCommentById(this.getLoggedInUser(), this.getCommentId(), (ErrorCollection)this);
        }
        return this.commentObject;
    }
}

