/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.issue.search.SearchRequest;

public final class FilterOperationsBean {
    private boolean showEdit = false;
    private boolean showSave = false;
    private boolean showSaveNew = false;
    private boolean showSaveAs = false;
    private boolean showReload = false;
    private boolean showViewSubscriptions = false;
    private boolean showInvalid;

    FilterOperationsBean() {
    }

    public boolean isShowInvalid() {
        return this.showInvalid;
    }

    public boolean isShowEdit() {
        return this.showEdit;
    }

    public void setShowEdit(boolean showEdit) {
        this.showEdit = showEdit;
    }

    public boolean isShowSave() {
        return this.showSave;
    }

    public void setShowSave(boolean showSave) {
        this.showSave = showSave;
    }

    public boolean isShowSaveNew() {
        return this.showSaveNew;
    }

    public void setShowSaveNew(boolean showSaveNew) {
        this.showSaveNew = showSaveNew;
    }

    public boolean isShowSaveAs() {
        return this.showSaveAs;
    }

    public void setShowInvalid(boolean showInvalid) {
        this.showInvalid = showInvalid;
    }

    public void setShowSaveAs(boolean showSaveAs) {
        this.showSaveAs = showSaveAs;
    }

    public boolean isShowReload() {
        return this.showReload;
    }

    public void setShowReload(boolean showReload) {
        this.showReload = showReload;
    }

    public boolean isShowViewSubscriptions() {
        return this.showViewSubscriptions;
    }

    public void setShowViewSubscriptions(boolean showViewSubscriptions) {
        this.showViewSubscriptions = showViewSubscriptions;
    }

    public boolean hasOperation() {
        return this.isShowViewSubscriptions() || this.isShowReload() || this.isShowSaveAs() || this.isShowSaveNew() || this.isShowSave() || this.isShowReload() || this.isShowEdit() || this.isShowInvalid();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FilterOperationsBean");
        sb.append("{showEdit=").append(this.showEdit);
        sb.append(", showSave=").append(this.showSave);
        sb.append(", showSaveNew=").append(this.showSaveNew);
        sb.append(", showSaveAs=").append(this.showSaveAs);
        sb.append(", showReload=").append(this.showReload);
        sb.append(", showViewSubscriptions=").append(this.showViewSubscriptions);
        sb.append(", showInvalid=").append(this.showInvalid);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterOperationsBean that = (FilterOperationsBean)o;
        if (this.showEdit != that.showEdit) {
            return false;
        }
        if (this.showReload != that.showReload) {
            return false;
        }
        if (this.showSave != that.showSave) {
            return false;
        }
        if (this.showSaveNew != that.showSaveNew) {
            return false;
        }
        if (this.showSaveAs != that.showSaveAs) {
            return false;
        }
        if (this.showViewSubscriptions != that.showViewSubscriptions) {
            return false;
        }
        return this.showInvalid == that.showInvalid;
    }

    public int hashCode() {
        int result = this.showEdit ? 1 : 0;
        result = 31 * result + (this.showSave ? 1 : 0);
        result = 31 * result + (this.showSaveNew ? 1 : 0);
        result = 31 * result + (this.showSaveAs ? 1 : 0);
        result = 31 * result + (this.showReload ? 1 : 0);
        result = 31 * result + (this.showViewSubscriptions ? 1 : 0);
        result = 31 * result + (this.showInvalid ? 1 : 0);
        return result;
    }

    public static FilterOperationsBean create(SearchRequest searchRequest, boolean validFilter, String username, boolean isAdvancedScreen) {
        FilterOperationsBean bean = new FilterOperationsBean();
        if (searchRequest != null) {
            boolean ownFilter = searchRequest.getOwnerUserName() == null || username != null && IdentifierUtils.equalsInLowerCase((String)searchRequest.getOwnerUserName(), (String)username);
            boolean searchRequestLoaded = searchRequest.isLoaded();
            boolean searchRequestModified = searchRequest.isModified();
            if (ownFilter) {
                if (searchRequestLoaded) {
                    bean.setShowEdit(true);
                    bean.setShowViewSubscriptions(true);
                    if (validFilter && searchRequestLoaded) {
                        bean.setShowSave(searchRequestModified);
                        bean.setShowSaveAs(true);
                    }
                }
                bean.setShowSaveNew(!searchRequestLoaded && validFilter);
            }
            bean.setShowReload(searchRequestLoaded && searchRequestModified);
            bean.setShowInvalid(!validFilter && !isAdvancedScreen);
        }
        return bean;
    }
}

