/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.web.action.JiraWebActionSupport;

enum WorkflowViewMode {
    TEXT("text"),
    DIAGRAM("diagram");

    private static final String COOKIE_NAME = "workflow-mode";
    private final String mode;

    private WorkflowViewMode(String mode) {
        this.mode = mode;
    }

    String getCookieValue() {
        return this.mode;
    }

    static WorkflowViewMode parseFromAction(JiraWebActionSupport jwas) {
        String value = jwas.getConglomerateCookieValue("AJS.conglomerate.cookie", COOKIE_NAME);
        for (WorkflowViewMode viewMode : WorkflowViewMode.values()) {
            if (!viewMode.getCookieValue().equals(value)) continue;
            return viewMode;
        }
        return DIAGRAM;
    }
}

