/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.vcs;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.web.action.admin.vcs.RepositoryActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Properties;

@WebSudoRequired
public class UpdateRepository
extends RepositoryActionSupport {
    public UpdateRepository(RepositoryManager repositoryManager, CvsRepositoryUtil cvsRepositoryUtil) {
        super(repositoryManager, cvsRepositoryUtil);
    }

    protected void doValidation() {
        if (this.id == null || this.id <= 0L) {
            this.addErrorMessage(this.getText("admin.errors.repositories.specify.repository.to.update"));
            return;
        }
        if (!TextUtils.stringSet((String)this.getName())) {
            this.addError("name", this.getText("admin.errors.repositories.specify.name"));
        } else {
            Repository repository = this.getRepositoryManager().getRepository(this.getName());
            if (repository != null && !this.id.equals(repository.getId())) {
                this.addError("name", this.getText("admin.errors.repositories.duplicate.name"));
            }
        }
        this.validateRepositoryParameters();
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Repository repository = this.getRepositoryManager().getRepository(this.getId());
        if (repository == null) {
            this.addErrorMessage(this.getText("admin.errors.repositories.error.retrieving"));
            return "error";
        }
        Properties properties = new Properties();
        properties.setProperty("cvslogfilepath", this.getLogFilePath());
        properties.setProperty("cvsroot", this.getCvsRoot());
        properties.setProperty("cvsmodulename", this.getModuleName());
        properties.setProperty("cvstimeout", String.valueOf(this.getTimeoutMillis()));
        if (this.getPassword() != null) {
            properties.setProperty("cvspassword", this.getPassword());
        }
        properties.setProperty("cvsfetchlog", String.valueOf(this.isFetchLog()));
        if (TextUtils.stringSet((String)this.getRepositoryBrowserURL())) {
            properties.setProperty("repositorybrowsertype", "VIEW_CVS");
            properties.setProperty("viewcvsbaseurl", this.getRepositoryBrowserURL());
            properties.setProperty("viewcvsrootparameter", this.getRepositoryBrowserRootParam());
        } else {
            properties.setProperty("repositorybrowsertype", "");
            properties.setProperty("viewcvsbaseurl", "");
            properties.setProperty("viewcvsrootparameter", "");
        }
        this.getRepositoryManager().updateRepository(this.id, this.getType(), this.getName(), this.getDescription(), properties);
        return this.getRedirect("ViewRepositories.jspa");
    }
}

