/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.web.action.AbstractBrowser;
import com.atlassian.jira.web.bean.GroupBrowserFilter;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import webwork.action.ActionContext;
import webwork.util.BeanUtil;

public class GroupPickerBrowser
extends AbstractBrowser {
    private List groups;
    private String formName;
    private String element;
    private boolean multiSelect = false;
    private List<String> previouslySelectedGroups = new ArrayList<String>();

    protected String doExecute() throws Exception {
        this.resetPager();
        BeanUtil.setProperties((Map)this.params, (Object)((Object)this.getFilter()));
        if (this.params.containsKey("nameFilter")) {
            if (this.params.containsKey("start")) {
                this.setStart(this.params.get("start").toString());
            } else {
                this.setStart("0");
            }
        }
        if (this.getBrowsableItems().size() <= this.getPager().getStart()) {
            this.setStart("0");
        }
        return super.doExecute();
    }

    @Override
    public PagerFilter getPager() {
        return this.getFilter();
    }

    @Override
    public void resetPager() {
        ActionContext.getSession().put("jira.grouppicker.filter", null);
    }

    public GroupBrowserFilter getFilter() {
        GroupBrowserFilter filter = (GroupBrowserFilter)((Object)ActionContext.getSession().get("jira.grouppicker.filter"));
        if (filter == null) {
            filter = new GroupBrowserFilter();
            ActionContext.getSession().put("jira.grouppicker.filter", filter);
        }
        return filter;
    }

    @Override
    public List getCurrentPage() {
        return this.getFilter().getCurrentPage(this.getBrowsableItems());
    }

    @Override
    public List getBrowsableItems() {
        if (this.groups == null) {
            try {
                this.groups = this.getFilter().getFilteredGroups();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception getting groups: " + e), (Throwable)e);
                return null;
            }
        }
        return this.groups;
    }

    public Collection getGroups() {
        return this.getBrowsableItems();
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public boolean getPermission() {
        return this.isHasPermission(27);
    }

    public String getPreviouslySelected() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.previouslySelectedGroups.isEmpty()) {
            stringBuilder.append(";");
        }
        for (String groupName : this.previouslySelectedGroups) {
            stringBuilder.append(this.encode(groupName));
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public void setPreviouslySelected(String previouslySelected) {
        if (previouslySelected.length() != 0) {
            String[] groups;
            previouslySelected = previouslySelected.substring(1, previouslySelected.length() - 1);
            for (String group : groups = previouslySelected.split(";")) {
                this.previouslySelectedGroups.add(this.decode(group));
            }
        }
    }

    public boolean wasPreviouslySelected(Group group) {
        return this.previouslySelectedGroups.contains(group.getName());
    }

    private String decode(String group) {
        return group.replaceAll("%59", ";");
    }

    private String encode(String group) {
        return group.replaceAll(";", "%59");
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.multiSelect = isMultiSelect;
    }
}

