/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.mapper;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.bc.scheme.mapper.SchemeGroupsToRoleTransformerService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.mapper.GroupToRoleMapping;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.scheme.mapper.AbstractGroupToRoleAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import webwork.action.ActionContext;

@WebSudoRequired
public class SchemeGroupToRoleMapperAction
extends AbstractGroupToRoleAction {
    private ProjectRoleService projectRoleService;
    private SchemeGroupsToRoleTransformerService schemeGroupsToRoleTransformerService;
    private List groupToRoleMappings;
    private static final String GROUP_TO_ROLE_SUFFIX = "_project_role";
    private Collection groupsWithoutGlobalUsePermission;
    private Collection groupsWithGlobalUsePermission;
    private Set groups;

    public SchemeGroupToRoleMapperAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ProjectRoleService projectRoleService, ApplicationProperties applicationProperties, SchemeGroupsToRoleTransformerService groupsToRoleTransformerService) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
        this.projectRoleService = projectRoleService;
        this.schemeGroupsToRoleTransformerService = groupsToRoleTransformerService;
    }

    public String doDefault() throws Exception {
        return "input";
    }

    protected void doValidation() {
        if (!this.isHasSelectedSchemeIds()) {
            this.addErrorMessage(this.getText("admin.scheme.group.role.mapper.no.selected.schemes"));
        } else if (this.getGroupToRoleMappings().isEmpty()) {
            this.addErrorMessage(this.getText("admin.scheme.group.role.mapper.no.selected.mappings"));
        }
    }

    protected String doExecute() throws Exception {
        StringBuilder redirectString = new StringBuilder("SchemeGroupToRoleTransformer!default.jspa");
        redirectString.append("?selectedSchemeType=");
        redirectString.append(this.getSelectedSchemeType());
        this.storeGroupToRoleMappingInSession();
        return this.forceRedirect(redirectString.toString());
    }

    public Collection getAvailableRoles() {
        return this.projectRoleService.getProjectRoles(this.getLoggedInUser(), (ErrorCollection)this);
    }

    public Collection getGroupsWithoutGlobalUsePermission() {
        if (this.groupsWithoutGlobalUsePermission == null) {
            this.groupsWithoutGlobalUsePermission = this.schemeGroupsToRoleTransformerService.getGroupsWithoutGlobalUsePermission(this.getGroups());
        }
        return this.groupsWithoutGlobalUsePermission;
    }

    public Collection getGroupsWithGlobalUsePermission() {
        if (this.groupsWithGlobalUsePermission == null) {
            this.groupsWithGlobalUsePermission = this.schemeGroupsToRoleTransformerService.getGroupsWithGlobalUsePermission(this.getGroups());
        }
        return this.groupsWithGlobalUsePermission;
    }

    public boolean isExistsGroupsWithGlobalUsePermission() {
        return !this.getGroupsWithGlobalUsePermission().isEmpty();
    }

    private List getGroupToRoleMappings() {
        if (this.groupToRoleMappings == null) {
            this.groupToRoleMappings = new ArrayList();
            Map params = ActionContext.getParameters();
            for (Object key : params.keySet()) {
                if (!key.toString().endsWith(GROUP_TO_ROLE_SUFFIX)) continue;
                String[] values = (String[])params.get(key);
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if ("-1".equals(value)) continue;
                    ProjectRole mappedProjectRole = this.getProjectRole(value);
                    this.groupToRoleMappings.add(new GroupToRoleMapping(mappedProjectRole, this.extractGroupName(key.toString())));
                }
            }
            Collections.sort(this.groupToRoleMappings, new GroupToRoleMappingComparator());
        }
        return this.groupToRoleMappings;
    }

    private ProjectRole getProjectRole(String idStr) {
        Long id = new Long(idStr);
        return this.projectRoleService.getProjectRole(this.getLoggedInUser(), id, (ErrorCollection)this);
    }

    private Set getGroups() {
        if (this.groups == null) {
            this.groups = this.getUniqueGroupsForSelectedSchemes();
        }
        return this.groups;
    }

    private String extractGroupName(String groupToRoleKey) {
        return groupToRoleKey.substring(0, groupToRoleKey.indexOf(GROUP_TO_ROLE_SUFFIX));
    }

    private void storeGroupToRoleMappingInSession() {
        ActionContext.getSession().put("__schemeGroupsToRoleMapping_sessionkey", this.getGroupToRoleMappings());
    }

    private static class GroupToRoleMappingComparator
    implements Comparator {
        private GroupToRoleMappingComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 != null && o2 != null) {
                GroupToRoleMapping groupToRoleMapping1 = (GroupToRoleMapping)o1;
                GroupToRoleMapping groupToRoleMapping2 = (GroupToRoleMapping)o2;
                String projectRoleName2 = groupToRoleMapping2.getProjectRole().getName();
                String projectRoleName1 = groupToRoleMapping1.getProjectRole().getName();
                int projectRoleNameComparison = projectRoleName1.compareTo(projectRoleName2);
                if (projectRoleNameComparison != 0) {
                    return projectRoleNameComparison;
                }
                String groupName2 = groupToRoleMapping2.getGroupName();
                String groupName1 = groupToRoleMapping1.getGroupName();
                return groupName1.compareTo(groupName2);
            }
            return 0;
        }
    }
}

