/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.scheme.AbstractSchemeAwareAction;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.web.action.admin.notification.ProjectAware;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class SelectProjectSecuritySchemeStep2
extends AbstractSchemeAwareAction
implements ProjectAware {
    private Long origSchemeId;
    private Long newSchemeId;
    private Long projectId;
    private GenericValue project;
    private Map levels = null;
    private static final String LEVEL_PREFIX = "level_";
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public SelectProjectSecuritySchemeStep2(IssueSecuritySchemeManager issueSecuritySchemeManager, IssueSecurityLevelManager issueSecurityLevelManager) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (this.origSchemeId != null && this.origSchemeId.equals(this.newSchemeId)) {
            this.addErrorMessage(this.getText("admin.errors.project.already.associated"));
        } else {
            this.changeLevels();
            this.associateProjectToScheme();
        }
        ManagerFactory.getIssueSecurityLevelManager().clearProjectLevels(this.project);
        return this.getRedirect(this.getRedirectURL());
    }

    private void changeLevels() throws Exception {
        Set keys = this.getOriginalSecurityLevels().keySet();
        for (Object origLevelObj : keys) {
            Object newLevelObj = this.getLevels().get(origLevelObj);
            Long newLevel = null;
            if (newLevelObj != null) {
                newLevel = (Long)newLevelObj;
            }
            List affectedIssues = this.getAffectedIssues((Long)origLevelObj);
            for (int i = 0; i < affectedIssues.size(); ++i) {
                GenericValue issue = (GenericValue)affectedIssues.get(i);
                issue.set("security", (Object)newLevel);
                issue.store();
                ComponentAccessor.getIssueIndexManager().reIndex(issue);
            }
        }
    }

    private Map getLevels() {
        if (this.levels == null) {
            this.levels = new HashMap();
            Map parameters = ActionContext.getParameters();
            Set keys = parameters.keySet();
            for (String key : keys) {
                Long longParam;
                if (!key.startsWith(LEVEL_PREFIX) || (longParam = ParameterUtils.getLongParam((Map)parameters, (String)key)) == -1L) continue;
                this.levels.put(new Long(key.substring(LEVEL_PREFIX.length())), longParam);
            }
        }
        return this.levels;
    }

    private void associateProjectToScheme() throws Exception {
        this.getSchemeManager().removeSchemesFromProject(this.getProject());
        if (this.newSchemeId != null) {
            GenericValue scheme = this.getSchemeManager().getScheme(this.newSchemeId);
            this.getSchemeManager().addSchemeToProject(this.getProject(), scheme);
        }
    }

    public List getAffectedIssues(Long levelId) {
        Long realLevelId = null;
        if (levelId != null && levelId != -1L) {
            realLevelId = levelId;
        }
        List affectedIssues = new ArrayList();
        try {
            affectedIssues = ComponentAccessor.getOfBizDelegator().findByAnd("Issue", EasyMap.build((Object)"project", (Object)this.projectId, (Object)"security", (Object)realLevelId));
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
        }
        return affectedIssues;
    }

    public List getTotalAffectedIssues() {
        ArrayList affectedIssues = new ArrayList();
        try {
            Map levels = this.getOriginalSecurityLevels();
            if (levels != null) {
                Set levelSet = levels.entrySet();
                for (Map.Entry mapEntry : levelSet) {
                    Long levelId = (Long)mapEntry.getKey();
                    affectedIssues.addAll(this.getAffectedIssues(levelId));
                }
            }
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
        }
        return affectedIssues;
    }

    public Map getOriginalSecurityLevels() {
        ListOrderedMap map = new ListOrderedMap();
        map.put(new Long(-1L), "None");
        if (this.origSchemeId != null) {
            for (IssueSecurityLevel issueSecurityLevel : this.issueSecurityLevelManager.getIssueSecurityLevels(this.origSchemeId.longValue())) {
                map.put(issueSecurityLevel.getId(), issueSecurityLevel.getName());
            }
        }
        return map;
    }

    public Map getNewSecurityLevels() {
        ListOrderedMap map = new ListOrderedMap();
        map.put(new Long(-1L), "None");
        if (this.newSchemeId != null) {
            for (IssueSecurityLevel issueSecurityLevel : this.issueSecurityLevelManager.getIssueSecurityLevels(this.newSchemeId.longValue())) {
                map.put(issueSecurityLevel.getId(), issueSecurityLevel.getName());
            }
        }
        return map;
    }

    public Long getOrigSchemeId() {
        return this.origSchemeId;
    }

    public void setOrigSchemeId(Long origSchemeId) {
        this.origSchemeId = origSchemeId == null || origSchemeId.equals(new Long(-1L)) ? null : origSchemeId;
    }

    public Long getNewSchemeId() {
        return this.newSchemeId;
    }

    public void setNewSchemeId(Long newSchemeId) {
        this.newSchemeId = newSchemeId == null || newSchemeId.equals(new Long(-1L)) ? null : newSchemeId;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public GenericValue getProject() throws GenericEntityException {
        if (this.project == null) {
            this.project = ManagerFactory.getProjectManager().getProject(this.getProjectId());
        }
        return this.project;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return this.issueSecuritySchemeManager;
    }

    @Override
    public String getRedirectURL() throws GenericEntityException {
        return "/plugins/servlet/project-config/" + this.getProject().getString("key") + "/issuesecurity";
    }

    public IssueSecurityLevelScheme getSecurityScheme(Long schemeId) throws GenericEntityException {
        return this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(schemeId);
    }

    public static String getLevelPrefix() {
        return LEVEL_PREFIX;
    }
}

