/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntityImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class AddIssueTypeScreenScheme
extends JiraWebActionSupport {
    private String schemeName;
    private String schemeDescription;
    private Long fieldScreenSchemeId;
    private Collection<FieldScreenScheme> fieldScreenSchemes;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;

    public AddIssueTypeScreenScheme(FieldScreenSchemeManager fieldScreenSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
    }

    public String doDefault() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    public String doExecute() {
        if (StringUtils.isBlank((String)this.getSchemeName())) {
            this.addError("schemeName", this.getText("admin.errors.add.issue.type.screen.scheme.empty.name"));
            return "error";
        }
        if (this.getFieldScreenSchemeId() == null) {
            this.addError("fieldScreenSchemeId", this.getText("admin.errors.screens.please.specify.a.screen.name"));
            return "error";
        }
        for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
            if (!this.getSchemeName().equals(issueTypeScreenScheme.getName())) continue;
            this.addError("schemeName", this.getText("admin.errors.screens.duplicate.screen.scheme.name"));
            return "error";
        }
        IssueTypeScreenSchemeImpl issueTypeScreenScheme = new IssueTypeScreenSchemeImpl(this.issueTypeScreenSchemeManager, null);
        issueTypeScreenScheme.setName(this.getSchemeName());
        issueTypeScreenScheme.setDescription(this.getSchemeDescription());
        issueTypeScreenScheme.store();
        IssueTypeScreenSchemeEntityImpl issueTypeScreenSchemeEntity = new IssueTypeScreenSchemeEntityImpl(this.issueTypeScreenSchemeManager, (GenericValue)null, this.fieldScreenSchemeManager, this.getConstantsManager());
        issueTypeScreenSchemeEntity.setIssueTypeId(null);
        issueTypeScreenSchemeEntity.setFieldScreenScheme(this.fieldScreenSchemeManager.getFieldScreenScheme(this.getFieldScreenSchemeId()));
        issueTypeScreenScheme.addEntity(issueTypeScreenSchemeEntity);
        return this.returnCompleteWithInlineRedirect(String.format("ConfigureIssueTypeScreenScheme.jspa?id=%d", issueTypeScreenScheme.getId()));
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public String getSchemeDescription() {
        return this.schemeDescription;
    }

    public void setSchemeDescription(String schemeDescription) {
        this.schemeDescription = schemeDescription;
    }

    public Long getFieldScreenSchemeId() {
        return this.fieldScreenSchemeId;
    }

    public void setFieldScreenSchemeId(Long fieldScreenSchemeId) {
        this.fieldScreenSchemeId = fieldScreenSchemeId;
    }

    public Collection<FieldScreenScheme> getFieldScreenSchemes() {
        if (this.fieldScreenSchemes == null) {
            this.fieldScreenSchemes = this.fieldScreenSchemeManager.getFieldScreenSchemes();
        }
        return this.fieldScreenSchemes;
    }
}

