/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.dashboards;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.user.ConfigurePortalPages;
import com.atlassian.jira.web.action.user.PortalPageLinkRenderer;
import com.atlassian.jira.web.action.user.UserProfileAction;
import com.atlassian.jira.web.action.util.PortalPageDisplayBean;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchViewHelper;
import com.atlassian.jira.web.ui.model.DropDownModel;
import com.atlassian.jira.web.ui.model.DropDownModelBuilder;
import com.atlassian.jira.web.ui.model.DropDownModelProvider;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewSharedDashboards
extends ConfigurePortalPages
implements UserProfileAction,
SharedEntitySearchAction,
DropDownModelProvider<PortalPageDisplayBean> {
    private static final PortalPageLinkRenderer NO_LINK_RENDERER = new PortalPageLinkRenderer(){

        @Override
        public String render(Long id, String name) {
            return "<span data-field=\"name\">" + TextUtils.htmlEncode((String)name) + "</span>";
        }
    };
    private final JiraAuthenticationContext authCtx;
    private final SearchRequestService searchRequestService;
    private final ShareTypeFactory shareTypeFactory;
    private final ConfigurePortalPages.PortalPageViewHelper dashboardViewHelper;
    private static final String OWNER = "filters.searchOwnerUserName";
    private static final String NAME = "filters.searchName";
    private static final String CONTENTONLY = "contentonly";

    public ViewSharedDashboards(PortalPageService portalPageService, JiraAuthenticationContext authCtx, EmailFormatter emailFormatter, GroupPermissionChecker groupPermissionChecker, FavouritesService favouritesService, PermissionManager permissionManager, ShareTypeFactory shareTypeFactory, UserFormatManager userFormatManager, WebResourceManager webResourceManager, UserHistoryManager userHistoryManager, SearchRequestService searchRequestService) {
        super(portalPageService, authCtx, emailFormatter, groupPermissionChecker, favouritesService, permissionManager, shareTypeFactory, userFormatManager, webResourceManager, userHistoryManager);
        this.authCtx = authCtx;
        this.searchRequestService = searchRequestService;
        this.shareTypeFactory = shareTypeFactory;
        this.dashboardViewHelper = new PortalViewHelper(shareTypeFactory, authCtx, ActionContext.getRequest().getContextPath(), "ViewSharedDashboards.jspa", portalPageService);
    }

    @Override
    public DropDownModel getDropDownModel(PortalPageDisplayBean displayBean, int listIndex) {
        DropDownModelBuilder builder = DropDownModelBuilder.builder();
        builder.setTopText(this.getText("common.words.operations"));
        builder.startSection().addItem(builder.item().setText(this.getText("shareddashboards.admin.cog.changeowner")).setAttr("id", "change_owner_" + displayBean.getId()).setAttr("class", "change-owner").setAttr("href", this.toUrl(displayBean, "ChangeSharedDashboardOwner!default.jspa", "dashboardId", true) + this.buildQueryStringForModel(ExecutingHttpRequest.get()))).addItem(builder.item().setText(this.getText("shareddashboards.delete")).setAttr("id", "delete_" + displayBean.getId()).setAttr("class", "delete-dashboard").setAttr("href", this.toUrl(displayBean, "DeleteSharedDashboard!default.jspa", "dashboardId", true) + this.buildQueryStringForModel(ExecutingHttpRequest.get())));
        builder.endSection();
        return builder.build();
    }

    private String buildQueryStringForModel(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder("");
        if (request.getMethod().equalsIgnoreCase("POST")) {
            builder.append("&");
            builder.append("searchOwnerUserName=");
            builder.append(JiraUrlCodec.encode((String)this.getSearchOwnerUserName()));
            builder.append("&searchName=");
            builder.append(JiraUrlCodec.encode((String)this.getSearchName()));
        } else if (this.getQueryString() != null) {
            builder.append("&");
            builder.append(this.getQueryString());
        }
        builder.append("&totalResultCount=").append(JiraUrlCodec.encode((String)("" + this.getTotalResultCount())));
        return builder.toString();
    }

    @Override
    public String doDefault() {
        return this.executeSearchView();
    }

    protected void doValidation() {
        super.doValidation();
    }

    protected String doExecute() {
        this.setReturnUrl(String.format("ViewSharedDashboards.jspa", new Object[0]));
        ActionContext.getSession().put(OWNER, this.getSearchOwnerUserName());
        ActionContext.getSession().put(NAME, this.getSearchName());
        return this.executeSearchView();
    }

    private String executeSearchView() {
        JiraServiceContext ctx = this.getJiraServiceContext();
        SharedEntitySearchViewHelper.SearchResult<PortalPage> searchResults = this.getPortalPageViewHelper().search(ctx);
        this.setSearchResults(searchResults);
        if (!ctx.getErrorCollection().hasAnyErrors()) {
            this.setPages(this.transformToDisplayBeans(searchResults.getResults()));
        }
        return this.isContentOnly() ? CONTENTONLY : "success";
    }

    @Override
    public ConfigurePortalPages.PortalPageViewHelper getPortalPageViewHelper() {
        return this.dashboardViewHelper;
    }

    @Override
    public PortalPageLinkRenderer getPortalPageLinkRenderer() {
        return NO_LINK_RENDERER;
    }

    private String getQueryString() {
        return ExecutingHttpRequest.get().getQueryString();
    }

    private static class PortalViewHelper
    extends ConfigurePortalPages.PortalPageViewHelper {
        public PortalViewHelper(ShareTypeFactory shareTypeFactory, JiraAuthenticationContext authCtx, String applicationContext, String actionUrlPrefix, PortalPageService portalPageService) {
            super(shareTypeFactory, authCtx, applicationContext, actionUrlPrefix, portalPageService);
        }

        @Override
        public SharedEntitySearchContext getEntitySearchContext() {
            return SharedEntitySearchContext.ADMINISTER;
        }
    }
}

