/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.GroupPermissionChecker;

public class GroupPermissionCheckerImpl
implements GroupPermissionChecker {
    private final PermissionManager permissionManager;
    private final GroupManager groupManager;

    public GroupPermissionCheckerImpl(PermissionManager permissionManager, GroupManager groupManager) {
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
    }

    @Override
    public boolean hasViewGroupPermission(String groupName, User user) {
        if (this.permissionManager.hasPermission(0, user)) {
            return true;
        }
        Group group = this.groupManager.getGroup(groupName);
        return group != null && user != null && this.groupManager.isUserInGroup(user, group);
    }
}

