/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import electric.xml.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StringRangeParameterClauseXmlHandler
implements ClauseXmlHandler {
    private final String LESS_THAN = "<=";
    private final String GREATER_THAN = ">=";
    private static final Logger log = Logger.getLogger(StringRangeParameterClauseXmlHandler.class);

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        TerminalClauseImpl clause;
        String xmlFieldId = el.getName();
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a clause for field with id '" + xmlFieldId + "' and no corresponding clause name could be found."));
            return new ClauseXmlHandler.FailedConversionResult(xmlFieldId);
        }
        String value = el.getAttributeValue("value");
        String operator = el.getAttributeValue("operator");
        if (StringUtils.isBlank((String)value) || StringUtils.isBlank((String)operator)) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        if (operator.equals("<=")) {
            clause = new TerminalClauseImpl(clauseName, Operator.LESS_THAN_EQUALS, value);
        } else if (operator.equals(">=")) {
            clause = new TerminalClauseImpl(clauseName, Operator.GREATER_THAN_EQUALS, value);
        } else {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        return new ClauseXmlHandler.FullConversionResult((Clause)clause);
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }
}

