/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.log4j.Logger;
import org.w3c.dom.NodeList;

public class CascadeSelectParameterClauseXmlHandler
implements ClauseXmlHandler {
    private static final Logger log = Logger.getLogger(CascadeSelectParameterClauseXmlHandler.class);
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;

    public CascadeSelectParameterClauseXmlHandler(JqlSelectOptionsUtil jqlSelectOptionsUtil) {
        this.jqlSelectOptionsUtil = (JqlSelectOptionsUtil)Assertions.notNull((String)"jqlSelectOptionsUtil", (Object)jqlSelectOptionsUtil);
    }

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String xmlFieldId = el.getName();
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a clause for field with id '" + xmlFieldId + "' and no corresponding clause name could be found."));
            return new ClauseXmlHandler.FailedConversionResult(xmlFieldId);
        }
        if (!this.isParent(el)) {
            return new ClauseXmlHandler.NoOpConversionResult();
        }
        Element child = this.getChild(el);
        if (child != null) {
            Option childOption = this.getOptionFromElement(child);
            Option parentOption = this.getOptionFromElement(el);
            if (childOption == null || parentOption == null) {
                return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
            }
            return new ClauseXmlHandler.FullConversionResult((Clause)new TerminalClauseImpl(clauseName, Operator.IN, (Operand)new FunctionOperand("cascadeOption", new String[]{parentOption.getOptionId().toString(), childOption.getOptionId().toString()})));
        }
        Option parentOption = this.getOptionFromElement(el);
        if (parentOption == null) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        return new ClauseXmlHandler.FullConversionResult((Clause)new TerminalClauseImpl(clauseName, Operator.IN, (Operand)new FunctionOperand("cascadeOption", new String[]{parentOption.getOptionId().toString()})));
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }

    private Option getOptionFromElement(Element el) {
        Long id = this.parseLong(el);
        return this.jqlSelectOptionsUtil.getOptionById(id);
    }

    private long parseLong(Element child) {
        return Long.parseLong(child.getAttribute("value"));
    }

    Element getParentElement(Element el) {
        try {
            return el.getParentElement();
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    private Element getChild(Element el) {
        if (this.getParentElement(el) != null && this.getParentElement(this.getParentElement(el)) != null) {
            Element root = this.getParentElement(this.getParentElement(el));
            Elements elements = root.getElements();
            while (elements.hasMoreElements()) {
                Element paramElement = elements.next();
                NodeList valueElements = paramElement.getElementsByTagName(el.getName());
                for (int i = 0; i < valueElements.getLength(); ++i) {
                    Element valueElement = (Element)valueElements.item(0);
                    if (this.isParent(valueElement)) continue;
                    return valueElement;
                }
            }
        }
        return null;
    }

    private boolean isParent(Element el) {
        String name = el.getAttribute("name");
        return !name.endsWith(":1");
    }
}

