/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Date;

public class UpgradeHistoryItemImpl
implements UpgradeHistoryItem {
    private final Date timePerformed;
    private final String targetBuildNumber;
    private final String targetVersion;
    private final String originalVersion;
    private final String originalBuildNumber;
    private final boolean inferred;

    public UpgradeHistoryItemImpl(Date timePerformed, String targetBuildNumber, String targetVersion, String originalBuildNumber, String originalVersion) {
        this(timePerformed, targetBuildNumber, targetVersion, originalBuildNumber, originalVersion, false);
    }

    public UpgradeHistoryItemImpl(Date timePerformed, String targetBuildNumber, String targetVersion, String originalBuildNumber, String originalVersion, boolean inferred) {
        this.timePerformed = timePerformed;
        this.originalVersion = originalVersion;
        this.originalBuildNumber = originalBuildNumber;
        this.targetBuildNumber = (String)Assertions.notNull((String)"targetBuildNumber", (Object)targetBuildNumber);
        this.targetVersion = (String)Assertions.notNull((String)"targetVersion", (Object)targetVersion);
        this.inferred = inferred;
    }

    @Override
    public Date getTimePerformed() {
        return this.timePerformed;
    }

    @Override
    public String getTargetBuildNumber() {
        return this.targetBuildNumber;
    }

    @Override
    public String getOriginalBuildNumber() {
        return this.originalBuildNumber;
    }

    @Override
    public String getTargetVersion() {
        return this.targetVersion;
    }

    @Override
    public String getOriginalVersion() {
        return this.originalVersion;
    }

    @Override
    public boolean isInferred() {
        return this.inferred;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeHistoryItemImpl that = (UpgradeHistoryItemImpl)o;
        if (this.inferred != that.inferred) {
            return false;
        }
        if (this.originalBuildNumber != null ? !this.originalBuildNumber.equals(that.originalBuildNumber) : that.originalBuildNumber != null) {
            return false;
        }
        if (this.originalVersion != null ? !this.originalVersion.equals(that.originalVersion) : that.originalVersion != null) {
            return false;
        }
        if (this.targetBuildNumber != null ? !this.targetBuildNumber.equals(that.targetBuildNumber) : that.targetBuildNumber != null) {
            return false;
        }
        if (this.targetVersion != null ? !this.targetVersion.equals(that.targetVersion) : that.targetVersion != null) {
            return false;
        }
        return !(this.timePerformed != null ? !this.timePerformed.equals(that.timePerformed) : that.timePerformed != null);
    }

    public int hashCode() {
        int result = this.timePerformed != null ? this.timePerformed.hashCode() : 0;
        result = 31 * result + (this.targetBuildNumber != null ? this.targetBuildNumber.hashCode() : 0);
        result = 31 * result + (this.targetVersion != null ? this.targetVersion.hashCode() : 0);
        result = 31 * result + (this.originalVersion != null ? this.originalVersion.hashCode() : 0);
        result = 31 * result + (this.originalBuildNumber != null ? this.originalBuildNumber.hashCode() : 0);
        result = 31 * result + (this.inferred ? 1 : 0);
        return result;
    }
}

