/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.multitenant.juc.MultiTenantExecutors;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.hsqldb.DatabaseManager;
import org.hsqldb.lib.HsqlTimer;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;

public final class ConnectionKeeper {
    private static final Logger log = Logger.getLogger(ConnectionKeeper.class);
    private final String ofbizHelperName;
    private final List<Connection> connections;
    private final int numberConnections;
    private final int sleepMillis;
    private final ScheduledExecutorService executor;
    private boolean running;

    public ConnectionKeeper(String ofbizHelperName, int numberConnections, int sleepMillis) {
        this.ofbizHelperName = ofbizHelperName;
        this.numberConnections = numberConnections;
        this.sleepMillis = sleepMillis;
        this.connections = this.openConnections();
        this.executor = MultiTenantExecutors.wrap((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory("ConnectionKeeper")));
    }

    public synchronized void start() {
        this.running = true;
        this.executor.scheduleWithFixedDelay(new ConnectionKeeperCommand(), 0L, this.sleepMillis, TimeUnit.MILLISECONDS);
    }

    public synchronized void shutdown() {
        this.running = false;
        this.executor.shutdown();
        this.closeAllConnections(this.connections, true);
        this.killTimerThread();
    }

    private void killTimerThread() {
        HsqlTimer timer = DatabaseManager.getTimer();
        if (timer != null) {
            Thread timerThread = timer.getThread();
            timer.shutDown();
            if (timerThread != null) {
                try {
                    timerThread.join(TimeUnit.SECONDS.toMillis(30L));
                    if (timerThread.isAlive()) {
                        log.warn((Object)"Timed out while waiting for HSQL timer to shutdown.");
                    }
                }
                catch (InterruptedException e) {
                    log.warn((Object)"Interrupted while waiting for HSQL timer to shutdown.");
                }
            }
        }
    }

    private List<Connection> openConnections() {
        ArrayList<Connection> connectionList = new ArrayList<Connection>();
        for (int i = 0; i < this.numberConnections; ++i) {
            try {
                Connection connection = ConnectionFactory.getConnection((String)this.ofbizHelperName);
                connectionList.add(connection);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)"Could not open connection.", (Throwable)e);
                continue;
            }
            catch (GenericEntityException e) {
                log.error((Object)"Could not open connection.", (Throwable)e);
            }
        }
        return connectionList;
    }

    private void closeAllConnections(List<Connection> connectionList, boolean shutdownHSQL) {
        Iterator<Connection> iterator = connectionList.iterator();
        while (iterator.hasNext()) {
            Connection connection = iterator.next();
            try {
                if (connection != null && !connection.isClosed()) {
                    if (shutdownHSQL && !iterator.hasNext()) {
                        this.shutdownHsql(connection);
                    }
                    connection.close();
                    log.debug((Object)"Closed connection.");
                    continue;
                }
                log.warn((Object)"Connection was closed or not initialised properly.");
            }
            catch (SQLException e) {
                log.error((Object)"Error closing connection.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownHsql(Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("SHUTDOWN");
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private class ConnectionKeeperCommand
    implements Runnable {
        private ConnectionKeeperCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionKeeper connectionKeeper = ConnectionKeeper.this;
            synchronized (connectionKeeper) {
                if (ConnectionKeeper.this.running) {
                    ArrayList temp = new ArrayList(ConnectionKeeper.this.connections);
                    ConnectionKeeper.this.connections.clear();
                    ConnectionKeeper.this.connections.addAll(ConnectionKeeper.this.openConnections());
                    ConnectionKeeper.this.closeAllConnections(temp, false);
                }
            }
        }
    }
}

