/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.config.database.DatabaseDriverRegisterer;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.JndiDatasource;
import com.atlassian.jira.config.database.SystemTenantDatabaseConfigurationLoader;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.startup.FailedStartupCheck;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.SystemTenant;
import com.atlassian.jira.startup.SystemTenantJiraHomeLocator;
import com.atlassian.multitenant.impl.TenantComponentMap;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;

public class SystemTenantProvider
implements com.atlassian.multitenant.SystemTenantProvider {
    private static final Logger log = Logger.getLogger(SystemTenantProvider.class);
    public static final String SYSTEM_TENANT_NAME = "_jiraSystemTenant";
    private static final String SYSTEM_TENANT_DATASOURCE_NAME = "defaultDS";
    public static final String SYSTEM_TENANT_DELEGATOR_NAME = "default";

    public TenantComponentMap getSystemTenant() {
        HashMap configMap = new HashMap();
        try {
            configMap.put(DatabaseConfig.class, this.getSystemDatabaseConfig());
        }
        catch (InvalidDatabaseDriverException e) {
            String errorMessage = this.getErrorMessageForDatabase(e);
            FailedStartupCheck failedCheck = new FailedStartupCheck("Database Driver Check", errorMessage);
            configMap.put(StartupCheck.class, failedCheck);
        }
        return new SystemTenant(configMap);
    }

    public DatabaseConfig getSystemDatabaseConfig() {
        DatabaseConfigurationLoader databaseConfigurationLoader = this.getDatabaseConfigLoader();
        if (databaseConfigurationLoader.configExists()) {
            return databaseConfigurationLoader.loadDatabaseConfiguration();
        }
        EntityConfigUtil entityConfigUtil = EntityConfigUtil.getInstance();
        DatasourceInfo datasourceInfo = entityConfigUtil.getDatasourceInfo(SYSTEM_TENANT_DATASOURCE_NAME);
        if (datasourceInfo != null) {
            Datasource datasource = null;
            if (datasourceInfo.getJndiDatasource() != null) {
                datasource = new JndiDatasource(datasourceInfo.getJndiDatasource());
            } else if (datasourceInfo.getJdbcDatasource() != null) {
                datasource = new JdbcDatasource(datasourceInfo.getJdbcDatasource());
            } else {
                log.warn((Object)"The datasource defined in entityengine.xml does not appear to be a valid JNDI or JDBC datasource.");
            }
            DatabaseConfig config = null;
            if (datasource != null) {
                log.info((Object)"Migrating from entityengine.xml specification of datasource to new dbconfig.xml form");
                config = new DatabaseConfig(SYSTEM_TENANT_DATASOURCE_NAME, SYSTEM_TENANT_DELEGATOR_NAME, datasourceInfo.getFieldTypeName(), datasourceInfo.getSchemaName(), datasource);
                databaseConfigurationLoader.saveDatabaseConfiguration(config);
            }
            try {
                entityConfigUtil.removeDelegator(SYSTEM_TENANT_DELEGATOR_NAME);
                entityConfigUtil.removeDatasource(SYSTEM_TENANT_DATASOURCE_NAME);
                return config;
            }
            catch (RuntimeException re) {
                log.error((Object)"Error removing default datasource and delegator from ofbiz", (Throwable)re);
            }
        }
        return null;
    }

    public DatabaseConfigurationLoader getDatabaseConfigLoader() {
        SystemTenantJiraHomeLocator.SystemJiraHome jiraHome = new SystemTenantJiraHomeLocator.SystemJiraHome();
        return new SystemTenantDatabaseConfigurationLoader(jiraHome);
    }

    public String getErrorMessageForDatabase(InvalidDatabaseDriverException e) {
        DatabaseDriverRegisterer registrar = DatabaseDriverRegisterer.forType(DatabaseType.forJdbcDriverClassName(e.driverClassName()));
        StringBuilder errorMessage = new StringBuilder("");
        if (registrar != null) {
            for (String s : registrar.getErrorMessage()) {
                errorMessage.append(s);
                errorMessage.append("\n");
            }
        } else {
            errorMessage.append(e.getMessage());
        }
        return errorMessage.toString();
    }
}

