/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.auth.trustedapps.CurrentApplicationFactory;
import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationBuilder;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationManager;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsConfigurationManager;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;

public class SeraphTrustedApplicationsManager
implements TrustedApplicationsManager,
TrustedApplicationsConfigurationManager {
    private final TrustedApplicationManager manager;
    private final CurrentApplicationFactory applicationFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public SeraphTrustedApplicationsManager(TrustedApplicationManager manager, CurrentApplicationFactory applicationFactory, JiraAuthenticationContext jiraAuthenticationContext) {
        Null.not("trustedApplicationManager", manager);
        Null.not("applicationFactory", applicationFactory);
        Null.not("jiraAuthenticationContext", jiraAuthenticationContext);
        this.manager = manager;
        this.applicationFactory = applicationFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public TrustedApplication getTrustedApplication(String id) {
        TrustedApplicationInfo app = this.manager.get(id);
        if (app != null && app.isValidKey()) {
            return app;
        }
        CurrentApplication currentApplication = this.getCurrentApplication();
        if (currentApplication.getID().equals(id) && currentApplication instanceof TrustedApplication) {
            return (TrustedApplication)currentApplication;
        }
        return null;
    }

    public CurrentApplication getCurrentApplication() {
        return this.applicationFactory.getCurrentApplication();
    }

    public Iterable<TrustedApplication> getTrustedApplications() {
        return Iterables.transform(this.manager.getAll(), (Function)Functions.identity());
    }

    public TrustedApplication addTrustedApplication(Application app, RequestConditions conditions) {
        TrustedApplicationInfo existingApplicationInfo = this.manager.get(app.getID());
        TrustedApplicationInfo storedApplicationInfo = existingApplicationInfo != null ? new TrustedApplicationBuilder().set(existingApplicationInfo).set(app).set(conditions).toInfo() : new TrustedApplicationBuilder().set(app).setName(app.getID()).set(conditions).toInfo();
        this.manager.store(this.jiraAuthenticationContext.getLoggedInUser(), storedApplicationInfo);
        return storedApplicationInfo;
    }

    public boolean deleteApplication(String applicationID) {
        return this.manager.delete(this.jiraAuthenticationContext.getLoggedInUser(), applicationID);
    }

    public Application getApplicationCertificate(String baseUrl) throws ApplicationRetriever.RetrievalException {
        return KeyFactory.getEncryptionProvider().getApplicationCertificate(baseUrl);
    }
}

