/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionImpl;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.project.version.VersionStore;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultVersionManager
implements VersionManager {
    private static final Logger log = Logger.getLogger(DefaultVersionManager.class);
    protected final IssueManager issueManager;
    protected final CollectionReorderer collectionReorderer;
    protected final AssociationManager associationManager;
    protected final IssueIndexManager issueIndexManager;
    protected final ProjectManager projectManager;
    protected final VersionStore versionStore;

    public DefaultVersionManager(IssueManager issueManager, CollectionReorderer collectionReorderer, AssociationManager associationManager, IssueIndexManager issueIndexManager, ProjectManager projectManager, VersionStore versionStore) {
        this.issueManager = issueManager;
        this.collectionReorderer = collectionReorderer;
        this.associationManager = associationManager;
        this.issueIndexManager = issueIndexManager;
        this.projectManager = projectManager;
        this.versionStore = versionStore;
    }

    public Version createVersion(String name, Date releaseDate, String description, GenericValue project, Long scheduleAfterVersion) throws CreateException {
        if (project == null) {
            throw new CreateException("You cannot create a version without a project.");
        }
        return this.createVersion(name, releaseDate, description, project.getLong("id"), scheduleAfterVersion);
    }

    public Version createVersion(String name, Date releaseDate, String description, Long projectId, Long scheduleAfterVersion) throws CreateException {
        HashMap<String, Object> versionParams = new HashMap<String, Object>();
        if (!TextUtils.stringSet((String)name)) {
            throw new CreateException("You cannot create a version without a name.");
        }
        if (projectId == null) {
            throw new CreateException("You cannot create a version without a project.");
        }
        versionParams.put("name", name);
        versionParams.put("project", projectId);
        if (scheduleAfterVersion != null) {
            if (scheduleAfterVersion == -1L) {
                this.moveAllVersionSequences(projectId);
                versionParams.put("sequence", 1L);
            } else {
                this.moveVersionSequences(scheduleAfterVersion);
                Long newSequence = this.getVersion(scheduleAfterVersion).getSequence() + 1L;
                versionParams.put("sequence", newSequence);
            }
        } else {
            versionParams.put("sequence", this.getMaxVersionSequence(projectId));
        }
        if (releaseDate != null) {
            versionParams.put("releasedate", new Timestamp(releaseDate.getTime()));
        }
        versionParams.put("description", description);
        return new VersionImpl(this.projectManager, this.versionStore.createVersion(versionParams));
    }

    public void moveToStartVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        this.collectionReorderer.moveToStart(versions, version);
        this.storeReorderedVersionList(versions);
    }

    public void increaseVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        this.collectionReorderer.increasePosition(versions, version);
        this.storeReorderedVersionList(versions);
    }

    public void decreaseVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        this.collectionReorderer.decreasePosition(versions, version);
        this.storeReorderedVersionList(versions);
    }

    public void moveToEndVersionSequence(Version version) {
        ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
        this.collectionReorderer.moveToEnd(versions, version);
        this.storeReorderedVersionList(versions);
    }

    public void moveVersionAfter(Version version, Long scheduleAfterVersionId) {
        if (version == null) {
            throw new IllegalArgumentException("You cannot move a null version");
        }
        if (version.getId() != null && !version.getId().equals(scheduleAfterVersionId)) {
            Object targetVersion = scheduleAfterVersionId == null ? this.getLastVersion(version.getProjectObject().getId()) : (scheduleAfterVersionId == -1L ? null : this.getVersion(scheduleAfterVersionId));
            ArrayList<Version> versions = new ArrayList<Version>(this.getAllVersions(version));
            this.collectionReorderer.moveToPositionAfter(versions, version, targetVersion);
            this.storeReorderedVersionList(versions);
        }
    }

    private void moveVersionSequences(Long scheduleAfterVersion) {
        Version startVersion = this.getVersion(scheduleAfterVersion);
        List<Version> versions = this.getVersions(startVersion.getProject());
        ArrayList<Version> versionsChanged = new ArrayList<Version>();
        for (Version version : versions) {
            if (version.getSequence() <= startVersion.getSequence()) continue;
            Long newSequence = version.getSequence() + 1L;
            version.setSequence(newSequence);
            versionsChanged.add(version);
        }
        this.versionStore.storeVersions(versionsChanged);
    }

    private void moveAllVersionSequences(Long project) {
        List<Version> versions = this.getVersions(project);
        ArrayList<Version> versionsChanged = new ArrayList<Version>();
        for (Version version : versions) {
            Long newSequence = version.getSequence() + 1L;
            version.setSequence(newSequence);
            versionsChanged.add(version);
        }
        this.versionStore.storeVersions(versionsChanged);
    }

    public void deleteVersion(Version version) {
        this.versionStore.deleteVersion(version.getGenericValue());
        this.reorderVersionsInProject(version);
    }

    public void editVersionDetails(Version version, String name, String description) {
        if (!TextUtils.stringSet((String)name)) {
            throw new IllegalArgumentException("You must specify a valid version name.");
        }
        if (this.isDuplicateName(version, name)) {
            throw new IllegalArgumentException("A version with this name already exists in this project.");
        }
        version.setName(name);
        version.setDescription(description);
        this.versionStore.storeVersion(version);
    }

    public void editVersionDetails(Version version, String versionName, String description, GenericValue project) {
        this.editVersionDetails(version, versionName, description);
    }

    public void releaseVersion(Version version, boolean release) {
        this.releaseVersions(Collections.singleton(version), release);
    }

    public void releaseVersions(Collection<Version> versions, boolean release) {
        ArrayList<Version> versionsChanged = new ArrayList<Version>();
        for (Version version : versions) {
            this.validateReleaseParams(version, release);
            version.setReleased(release);
            versionsChanged.add(version);
        }
        if (!versionsChanged.isEmpty()) {
            this.versionStore.storeVersions(versionsChanged);
        }
    }

    public void moveIssuesToNewVersion(List issues, Version currentVersion, Version swapToVersion) throws IndexException {
        if (!issues.isEmpty()) {
            this.swapVersionAssociations(currentVersion, swapToVersion, "IssueFixVersion", issues);
            this.issueIndexManager.reIndexIssues((Collection)issues);
        }
    }

    public void archiveVersions(String[] idsToArchive, String[] idsToUnarchive) {
        Version version;
        ArrayList<Version> versionsChanged = new ArrayList<Version>();
        for (String anIdsToArchive : idsToArchive) {
            Long archiveId = new Long(anIdsToArchive);
            version = this.getVersion(archiveId);
            if (version == null || version.isArchived()) continue;
            version.setArchived(true);
            versionsChanged.add(version);
        }
        for (String anIdsToUnarchive : idsToUnarchive) {
            Long unArchiveId = new Long(anIdsToUnarchive);
            version = this.getVersion(unArchiveId);
            if (version == null || !version.isArchived()) continue;
            version.setArchived(false);
            versionsChanged.add(version);
        }
        if (!versionsChanged.isEmpty()) {
            this.versionStore.storeVersions(versionsChanged);
        }
    }

    public void archiveVersion(Version version, boolean archive) {
        version.setArchived(archive);
        this.versionStore.storeVersion(version);
    }

    public void editVersionReleaseDate(Version version, Date duedate) {
        if (version == null) {
            throw new IllegalArgumentException("You must specify a valid version.");
        }
        version.setReleaseDate(duedate);
        this.versionStore.storeVersion(version);
    }

    public boolean isVersionOverDue(Version version) {
        if (version.getReleaseDate() == null || version.isArchived() || version.isReleased()) {
            return false;
        }
        Calendar releaseDate = Calendar.getInstance();
        releaseDate.setTime(version.getReleaseDate());
        Calendar lastMidnight = Calendar.getInstance();
        lastMidnight.set(11, 0);
        lastMidnight.set(12, 0);
        lastMidnight.set(13, 0);
        lastMidnight.set(14, 0);
        return releaseDate.before(lastMidnight);
    }

    public Collection<Version> getVersionsUnarchived(Long projectId) {
        List<GenericValue> versionGvs = this.versionStore.getVersionsByProject(projectId);
        return this.filterVersions(versionGvs, Collections.singletonMap("archived", null));
    }

    public Collection<Version> getVersionsArchived(GenericValue projectGV) {
        List<GenericValue> versionGvs = this.versionStore.getVersionsByProject(projectGV.getLong("id"));
        return this.filterVersions(versionGvs, Collections.singletonMap("archived", "true"));
    }

    public Collection<Version> getVersionsArchived(Project project) {
        List<GenericValue> versionGvs = this.versionStore.getVersionsByProject(project.getId());
        return this.filterVersions(versionGvs, Collections.singletonMap("archived", "true"));
    }

    public List<Version> getVersions(GenericValue project) {
        return this.getVersions(project.getLong("id"));
    }

    public List<Version> getVersions(Long projectId) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        List<GenericValue> versionGvs = this.versionStore.getVersionsByProject(projectId);
        ArrayList<Version> versions = new ArrayList<Version>();
        for (GenericValue versionGV : versionGvs) {
            versions.add(new VersionImpl(this.projectManager, versionGV));
        }
        return versions;
    }

    public List<Version> getVersions(Project project) {
        return this.getVersions(project.getId());
    }

    public Collection<Version> getVersionsByName(String versionName) {
        Assertions.notNull((String)"versionName", (Object)versionName);
        List<GenericValue> versionGvs = this.versionStore.getVersionsByName(versionName);
        ArrayList<Version> versions = new ArrayList<Version>();
        for (GenericValue versionGV : versionGvs) {
            versions.add(new VersionImpl(this.projectManager, versionGV));
        }
        return versions;
    }

    public Collection<Version> getAffectedVersionsByIssue(GenericValue issue) {
        return this.getVersionsByIssue(issue, "IssueVersion");
    }

    public Collection<Version> getAffectedVersionsFor(Issue issue) {
        return this.getVersionsByIssue(issue.getGenericValue(), "IssueVersion");
    }

    public Collection<Version> getFixVersionsByIssue(GenericValue issue) {
        return this.getVersionsByIssue(issue, "IssueFixVersion");
    }

    public Collection<Version> getFixVersionsFor(Issue issue) {
        return this.getVersionsByIssue(issue.getGenericValue(), "IssueFixVersion");
    }

    public Collection<Version> getAllVersions() {
        return this.queryDatabase(null);
    }

    public Collection<Version> getAllVersionsReleased(boolean includeArchived) {
        Map params = EasyMap.build((Object)"released", (Object)"true");
        if (!includeArchived) {
            params.put("archived", null);
        }
        return this.queryDatabase(params);
    }

    public Collection<Version> getAllVersionsUnreleased(boolean includeArchived) {
        Map params = EasyMap.build((Object)"released", null);
        if (!includeArchived) {
            params.put("archived", null);
        }
        return this.queryDatabase(params);
    }

    protected Collection<Version> getVersionsByIssue(GenericValue issue, String relationName) {
        try {
            List<GenericValue> versionGVs = this.associationManager.getSinkFromSource(issue, "Version", relationName, false);
            ArrayList<Version> versions = new ArrayList<Version>();
            for (GenericValue versionGV : versionGVs) {
                versions.add(new VersionImpl(this.projectManager, versionGV));
            }
            return versions;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving versions for issue with id '" + issue.getLong("id") + "'.", (Throwable)e);
        }
    }

    public Collection<Version> getVersions(List<Long> ids) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Long id : ids) {
            versions.add(this.getVersion(id));
        }
        return versions;
    }

    public Collection<Version> getVersionsUnreleased(Long projectId, boolean includeArchived) {
        List<GenericValue> versionGvs = this.versionStore.getVersionsByProject(projectId);
        Map params = EasyMap.build((Object)"released", null);
        if (!includeArchived) {
            params.put("archived", null);
        }
        return this.filterVersions(versionGvs, params);
    }

    public Collection<Version> getVersionsReleased(Long projectId, boolean includeArchived) {
        List<GenericValue> versionGvs = this.versionStore.getVersionsByProject(projectId);
        Map params = EasyMap.build((Object)"released", (Object)"true");
        if (!includeArchived) {
            params.put("archived", null);
        }
        return this.filterVersions(versionGvs, params);
    }

    public Collection<Version> getVersionsReleasedDesc(Long projectId, boolean includeArchived) {
        ArrayList<Version> released = new ArrayList<Version>(this.getVersionsReleased(projectId, includeArchived));
        Collections.reverse(released);
        return released;
    }

    public Version getVersion(Long id) {
        if (this.versionStore.getVersion(id) != null) {
            return new VersionImpl(this.projectManager, this.versionStore.getVersion(id));
        }
        return null;
    }

    public Version getVersion(Long projectId, String versionName) {
        List<GenericValue> versionGvs = this.versionStore.getVersionsByProject(projectId);
        List<Version> versions = this.filterVersions(versionGvs, EasyMap.build((Object)"name", (Object)versionName));
        if (versions != null && versions.size() == 1) {
            return versions.get(0);
        }
        return null;
    }

    public Collection<GenericValue> getAllAffectedIssues(Collection<Version> versions) {
        try {
            HashSet<GenericValue> affectedIssues = new HashSet<GenericValue>();
            for (Version version : versions) {
                affectedIssues.addAll(this.issueManager.getIssuesByEntity("IssueVersion", version.getGenericValue()));
                affectedIssues.addAll(this.issueManager.getIssuesByEntity("IssueFixVersion", version.getGenericValue()));
            }
            return affectedIssues;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error getting issue for versions " + ToStringBuilder.reflectionToString(versions), (Throwable)e);
        }
    }

    protected IssueFactory getIssueFactory() {
        return ComponentAccessor.getIssueFactory();
    }

    public Collection<Version> getOtherVersions(Version version) {
        ArrayList<Version> otherVersions = new ArrayList<Version>(this.getAllVersions(version));
        otherVersions.remove(version);
        return otherVersions;
    }

    public Collection<Version> getOtherUnarchivedVersions(Version version) {
        ArrayList<Version> otherUnarchivedVersions = new ArrayList<Version>(this.getVersionsUnarchived(version.getProjectObject().getId()));
        otherUnarchivedVersions.remove(version);
        return otherUnarchivedVersions;
    }

    public Collection<GenericValue> getFixIssues(Version version) {
        try {
            return this.issueManager.getIssuesByEntity("IssueFixVersion", version.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unabled to get fix issues for version " + version, (Throwable)e);
        }
    }

    public Collection<Issue> getIssuesWithFixVersion(Version version) {
        return this.getIssueFactory().getIssues(this.getFixIssues(version));
    }

    public Collection<GenericValue> getAffectsIssues(Version version) {
        try {
            return this.issueManager.getIssuesByEntity("IssueVersion", version.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unabled to get affected issues for version " + version, (Throwable)e);
        }
    }

    public Collection<Issue> getIssuesWithAffectsVersion(Version version) {
        return this.getIssueFactory().getIssues(this.getAffectsIssues(version));
    }

    private List<Version> getAllVersions(Version version) {
        return this.getVersions(version.getLong("project"));
    }

    private void swapVersionAssociations(Version swapFromVersion, Version swapToVersion, String issueRelation, List issues) {
        try {
            if (swapFromVersion != null && swapToVersion != null && issueRelation != null && issues.isEmpty()) {
                this.associationManager.swapAssociation("Issue", issueRelation, swapFromVersion.getGenericValue(), swapToVersion.getGenericValue());
            } else if (swapFromVersion != null && swapToVersion != null && issueRelation != null && !issues.isEmpty()) {
                this.associationManager.swapAssociation(issues, issueRelation, swapFromVersion.getGenericValue(), swapToVersion.getGenericValue());
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unabled to swapVersionAssociations for versions " + swapFromVersion + " and " + swapToVersion, (Throwable)e);
        }
    }

    public boolean isDuplicateName(Version currentVersion, String name) {
        for (Version version : currentVersion.getProjectObject().getVersions()) {
            if (currentVersion.getId().equals(version.getId()) || !name.trim().equalsIgnoreCase(version.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isDuplicateName(Version currentVersion, String name, GenericValue project) {
        return this.isDuplicateName(currentVersion, name);
    }

    private void validateDeleteParams(Version version, String affectsAction, Long affectsSwapVersionId, String fixAction, Long fixSwapVersionId) {
        if (version == null) {
            throw new IllegalArgumentException("You must specify a valid version.");
        }
        if (!affectsAction.equalsIgnoreCase("remove") && !affectsAction.equalsIgnoreCase("swap")) {
            throw new IllegalArgumentException("Illegal action specified for issues associated with this affects version.");
        }
        if (affectsAction.equals("swap") && version.getId().equals(affectsSwapVersionId)) {
            throw new IllegalArgumentException("You cannot move the issues to the version being deleted.");
        }
        if (!fixAction.equalsIgnoreCase("remove") && !fixAction.equalsIgnoreCase("swap")) {
            throw new IllegalArgumentException("Illegal action specified for issues associated with this fix version.");
        }
        if (fixAction.equals("swap") && version.getId().equals(fixSwapVersionId)) {
            throw new IllegalArgumentException("You cannot change the fix version to the version being deleted.");
        }
    }

    private void validateMergeParams(Version version, Long mergeToId) {
        GenericValue mergeFromProject = version.getProject();
        GenericValue mergeToProject = this.getVersion(mergeToId).getProject();
        if (!this.getVersions(mergeFromProject).contains(version)) {
            throw new IllegalArgumentException("The version to merge from is invalid.");
        }
        if (mergeToId == null || !this.getVersions(mergeToProject).contains(this.getVersion(mergeToId))) {
            throw new IllegalArgumentException("You must select a version to merge to.");
        }
    }

    private void validateReleaseParams(Version version, boolean release) {
        if (version == null && release) {
            throw new IllegalArgumentException("Please select a version to release");
        }
        if (version == null && !release) {
            throw new IllegalArgumentException("Please select a version to unrelease.");
        }
    }

    private Version getLastVersion(Long projectId) {
        long maxSequence = 0L;
        Version lastVersion = null;
        for (Version version : this.getVersions(projectId)) {
            if (version.getSequence() == null || version.getSequence() < maxSequence) continue;
            maxSequence = version.getSequence();
            lastVersion = version;
        }
        return lastVersion;
    }

    private long getMaxVersionSequence(Long projectId) {
        long maxSequence = 1L;
        for (Version version : this.getVersions(projectId)) {
            if (version.getSequence() == null || version.getSequence() < maxSequence) continue;
            maxSequence = version.getSequence() + 1L;
        }
        return maxSequence;
    }

    public void storeReorderedVersionList(List<Version> versions) {
        ArrayList<Version> versionsChanged = new ArrayList<Version>();
        for (int i = 0; i < versions.size(); ++i) {
            long expectedSequenceNumber = (long)i + 1L;
            Version version = versions.get(i);
            if (expectedSequenceNumber == version.getSequence()) continue;
            version.setSequence(Long.valueOf(expectedSequenceNumber));
            versionsChanged.add(version);
        }
        this.versionStore.storeVersions(versionsChanged);
    }

    void reorderVersionsInProject(Version version) {
        this.storeReorderedVersionList(this.getAllVersions(version));
    }

    private List<Version> filterVersions(List<GenericValue> versionGvs, Map<String, Object> params) {
        List filterredVersionGvs = EntityUtil.filterByAnd(versionGvs, params);
        ArrayList<Version> versions = new ArrayList<Version>();
        for (GenericValue versionGV : filterredVersionGvs) {
            versions.add(new VersionImpl(this.projectManager, versionGV));
        }
        return versions;
    }

    private List<Version> queryDatabase(Map<String, Object> params) {
        List versionGvs = EntityUtil.filterByAnd(this.versionStore.getAllVersions(), params);
        ArrayList<Version> versions = new ArrayList<Version>();
        for (GenericValue versionGV : versionGvs) {
            versions.add(new VersionImpl(this.projectManager, versionGV));
        }
        return versions;
    }
}

