/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ProjectKeyRegexValidator
implements Validator {
    @VisibleForTesting
    static final List<String> BANNED_CHARS = Arrays.asList("-", ".", "<", ">", "&", "#", "\"", "'");
    private ProjectManager projectManager;
    private I18nHelper i18nHelper;

    @Override
    public Validator.Result validate(String value) {
        try {
            Pattern projectKeyPattern = Pattern.compile(value);
            List projects = this.getProjectManager().getProjectObjects();
            for (Project project : projects) {
                if (projectKeyPattern.matcher(project.getKey()).matches()) continue;
                return new Failure(this.getI18nHelper().getText("admin.advancedconfiguration.projectkey.regex.error.existingproject"));
            }
            for (String bannedChar : BANNED_CHARS) {
                if (!Pattern.matches(value, String.format("%sAB", bannedChar)) && !Pattern.matches(value, String.format("A%sB", bannedChar)) && !Pattern.matches(value, String.format("AB%s", bannedChar))) continue;
                return new Failure(this.getI18nHelper().getText("admin.advancedconfiguration.projectkey.regex.error.banned.character", bannedChar));
            }
            if (!StringUtils.isStringAllASCII((String)value)) {
                return new Failure(this.getI18nHelper().getText("admin.advancedconfiguration.projectkey.regex.error.nonascii"));
            }
            return new Success(value);
        }
        catch (PatternSyntaxException e) {
            return new Failure(this.getI18nHelper().getText("admin.advancedconfiguration.projectkey.regex.error.invalid", e.getLocalizedMessage()));
        }
    }

    @VisibleForTesting
    ProjectManager getProjectManager() {
        if (this.projectManager == null) {
            this.projectManager = ComponentManager.getInstance().getProjectManager();
        }
        return this.projectManager;
    }

    @VisibleForTesting
    I18nHelper getI18nHelper() {
        if (this.i18nHelper == null) {
            this.i18nHelper = ComponentManager.getInstance().getJiraAuthenticationContext().getI18nHelper();
        }
        return this.i18nHelper;
    }
}

