/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat.descriptors;

import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatModuleDescriptors;
import com.atlassian.jira.plugin.util.ModuleDescriptors;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;

public class DefaultUserFormatModuleDescriptors
implements UserFormatModuleDescriptors {
    private final PluginAccessor pluginAccessor;
    private final ModuleDescriptors.Orderings moduleDescriptorOrderings;

    public DefaultUserFormatModuleDescriptors(PluginAccessor pluginAccessor, ModuleDescriptors.Orderings moduleDescriptorOrderings) {
        this.pluginAccessor = pluginAccessor;
        this.moduleDescriptorOrderings = moduleDescriptorOrderings;
    }

    @Override
    public Iterable<UserFormatModuleDescriptor> forType(final String type) {
        return Iterables.filter(this.get(), (Predicate)new Predicate<UserFormatModuleDescriptor>(){

            public boolean apply(@Nullable UserFormatModuleDescriptor aUserFormatModuleDescriptor) {
                return aUserFormatModuleDescriptor.getType().equals(type);
            }
        });
    }

    @Override
    public UserFormatModuleDescriptor withKey(String completeKey) {
        ModuleDescriptor enabledPluginModule = this.pluginAccessor.getEnabledPluginModule(completeKey);
        if (enabledPluginModule instanceof UserFormatModuleDescriptor) {
            return (UserFormatModuleDescriptor)enabledPluginModule;
        }
        return null;
    }

    @Override
    public Iterable<UserFormatModuleDescriptor> get() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(UserFormatModuleDescriptor.class);
    }

    @Override
    public UserFormatModuleDescriptor defaultFor(String type) {
        Iterable<UserFormatModuleDescriptor> descriptorsForType = this.forType(type);
        if (!Iterables.isEmpty(descriptorsForType)) {
            return (UserFormatModuleDescriptor)this.moduleDescriptorOrderings.byOrigin().compound(this.moduleDescriptorOrderings.natural()).min(descriptorsForType);
        }
        return null;
    }
}

