/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractUnresolvedIssuesFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnresolvedIssuesByIssueTypeFragment
extends AbstractUnresolvedIssuesFragment
implements ProjectTabPanelFragment {
    private static final Logger log = Logger.getLogger(UnresolvedIssuesByIssueTypeFragment.class);
    private static final String FRAGMENT_ID = "unresolvedissuesbyissuetype";
    private final ApplicationProperties applicationProperties;
    private final ConstantsManager constantsManager;

    public UnresolvedIssuesByIssueTypeFragment(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager) {
        super(templatingEngine, authenticationContext);
        this.applicationProperties = applicationProperties;
        this.constantsManager = constantsManager;
    }

    @Override
    public String getId() {
        return FRAGMENT_ID;
    }

    @Override
    String getIssueFieldConstant() {
        return "issuetype";
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("issueTypes", this.getIssueTypes(ctx));
        velocityParams.put("urlUtil", new IssueTypeUrlUtil(this.getSearchRequest(ctx), this.authenticationContext.getLoggedInUser(), this.applicationProperties));
        return velocityParams;
    }

    StatisticMapWrapper getIssueTypes(BrowseContext ctx) {
        try {
            StatisticMapWrapper map = this.getStatsBean(ctx).getAllFilterBy("issuetype");
            return map;
        }
        catch (SearchException e) {
            log.error((Object)("Could not search for issue types in project '" + ctx.getProject().getKey() + "'"), (Throwable)e);
            return null;
        }
    }

    public static class IssueTypeUrlUtil
    extends AbstractUrlFragmentUtil<IssueType> {
        public IssueTypeUrlUtil(SearchRequest searchRequest, User user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(IssueType issueType) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            builder.issueType().eq(issueType.getName());
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.issueType(SortOrder.ASC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

