/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingKeyboardShortcutManager
implements KeyboardShortcutManager {
    private static Logger log = LoggerFactory.getLogger(CachingKeyboardShortcutManager.class);
    private static final String REST_PREFIX = "/rest/api/1.0/shortcuts/";
    private static final String REST_RESOURCE = "/shortcuts.js";
    private static final String REQUEST_CACHE_KEY = "keyboard.shortcuts.contexts";
    private final Map<String, KeyboardShortcut> shortcuts = new ConcurrentHashMap<String, KeyboardShortcut>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final BuildUtilsInfo buildUtilsInfo;
    private final PluginAccessor pluginAccessor;
    private final WebResourceIntegration webResourceIntegration;
    private final JiraAuthenticationContext authenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final ResettableLazyReference<List<KeyboardShortcut>> allShortcuts = new ResettableLazyReference<List<KeyboardShortcut>>(){

        protected List<KeyboardShortcut> create() throws Exception {
            ArrayList<KeyboardShortcut> ret = new ArrayList<KeyboardShortcut>(CachingKeyboardShortcutManager.this.shortcuts.values());
            Collections.sort(ret);
            return ret;
        }
    };
    private final ResettableLazyReference<String> allShortcutsMD5 = new ResettableLazyReference<String>(){

        protected String create() throws Exception {
            MessageDigest messageDigest = this.getMessageDigest("MD5");
            if (messageDigest == null) {
                messageDigest = this.getMessageDigest("SHA");
            }
            if (messageDigest == null) {
                throw new RuntimeException("Unable to retrieve a valid message digest!");
            }
            messageDigest.update(CachingKeyboardShortcutManager.this.getAllShortcuts().toString().getBytes());
            byte[] digest = messageDigest.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            String hash = bigInt.toString(16);
            return CachingKeyboardShortcutManager.REST_PREFIX + CachingKeyboardShortcutManager.this.buildUtilsInfo.getCurrentBuildNumber() + "/" + hash + CachingKeyboardShortcutManager.REST_RESOURCE;
        }

        private MessageDigest getMessageDigest(String digestName) {
            try {
                return MessageDigest.getInstance(digestName);
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
    };

    public CachingKeyboardShortcutManager(BuildUtilsInfo buildUtilsInfo, PluginAccessor pluginAccessor, WebResourceIntegration webResourceIntegration, JiraAuthenticationContext authenticationContext, UserPreferencesManager userPreferencesManager) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.pluginAccessor = pluginAccessor;
        this.webResourceIntegration = webResourceIntegration;
        this.authenticationContext = authenticationContext;
        this.userPreferencesManager = userPreferencesManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.clear();
            this.allShortcuts.reset();
            this.allShortcutsMD5.reset();
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(KeyboardShortcutModuleDescriptor.class);
            for (KeyboardShortcutModuleDescriptor descriptor : descriptors) {
                this.shortcuts.put(descriptor.getCompleteKey(), (KeyboardShortcut)descriptor.getModule());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShortcut(String pluginModuleKey, KeyboardShortcut shortcut) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.put(pluginModuleKey, shortcut);
            this.allShortcuts.reset();
            this.allShortcutsMD5.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShortcut(String pluginModuleKey) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.remove(pluginModuleKey);
            this.allShortcuts.reset();
            this.allShortcutsMD5.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<KeyboardShortcut> getActiveShortcuts() {
        return this.listActiveShortcutsUniquePerContext(Collections.<String, Object>emptyMap());
    }

    public List<KeyboardShortcut> listActiveShortcutsUniquePerContext(final Map<String, Object> userContext) {
        Collection filter = Collections2.filter(this.getAllShortcuts(), (Predicate)new Predicate<KeyboardShortcut>(){

            public boolean apply(KeyboardShortcut keyboardShortcut) {
                try {
                    return keyboardShortcut.shouldDisplay(userContext);
                }
                catch (RuntimeException e) {
                    log.warn("failed to evaluate the conditions of a keyboard shortcut: " + keyboardShortcut, (Throwable)e);
                    return false;
                }
            }
        });
        return this.eliminateDuplicateShortcutsPerContext(new LinkedList<KeyboardShortcut>(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyboardShortcut> getAllShortcuts() {
        this.lock.readLock().lock();
        try {
            List list = (List)this.allShortcuts.get();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void requireShortcutsForContext(KeyboardShortcutManager.Context context) {
        this.getRequiredContexts().add(context);
    }

    private List<KeyboardShortcut> eliminateDuplicateShortcutsPerContext(Collection<KeyboardShortcut> keyboardShortcuts) {
        HashMap active = Maps.newHashMapWithExpectedSize((int)keyboardShortcuts.size());
        for (KeyboardShortcut shortcut : keyboardShortcuts) {
            ShortcutCacheKey key = ShortcutCacheKey.makeCacheKey(shortcut);
            KeyboardShortcut overridden = active.put(key, shortcut);
            if (overridden == null) continue;
            log.debug("Keyboard shortcut '{}' overrides '{}' in context {} with keys: {}", new Object[]{shortcut.getDescriptionI18nKey(), overridden.getDescriptionI18nKey(), key.context, key.shortcuts});
        }
        ArrayList activeShortcuts = Lists.newArrayList(active.values());
        Collections.sort(activeShortcuts);
        return activeShortcuts;
    }

    private Set<KeyboardShortcutManager.Context> getRequiredContexts() {
        Map requestCache = this.webResourceIntegration.getRequestCache();
        LinkedHashSet requiredContexts = (LinkedHashSet)requestCache.get(REQUEST_CACHE_KEY);
        if (requiredContexts == null) {
            requiredContexts = new LinkedHashSet();
            requestCache.put(REQUEST_CACHE_KEY, requiredContexts);
        }
        return requiredContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String includeShortcuts() {
        UrlBuilder url;
        this.lock.readLock().lock();
        try {
            url = new UrlBuilder((String)this.allShortcutsMD5.get());
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (KeyboardShortcutManager.Context context : this.getRequiredContexts()) {
            url.addParameterUnsafe("context", context.toString());
        }
        return url.asUrlString();
    }

    public boolean isKeyboardShortcutsEnabled() {
        User user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return true;
        }
        Preferences userPrefs = this.userPreferencesManager.getPreferences(user);
        return !userPrefs.getBoolean("user.keyboard.shortcuts.disabled");
    }

    static final class ShortcutCacheKey {
        final KeyboardShortcutManager.Context context;
        final ImmutableSet<ImmutableList<String>> shortcuts;

        public static ShortcutCacheKey makeCacheKey(@Nonnull KeyboardShortcut shortcut) {
            Preconditions.checkNotNull((Object)shortcut, (Object)"shortcut");
            return new ShortcutCacheKey(shortcut.getContext(), shortcut.getShortcuts());
        }

        private ShortcutCacheKey(KeyboardShortcutManager.Context context, Set<List<String>> shortcuts) {
            this.context = context;
            this.shortcuts = this.makeImmutable(shortcuts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShortcutCacheKey that = (ShortcutCacheKey)o;
            if (this.context != that.context) {
                return false;
            }
            return this.shortcuts.equals(that.shortcuts);
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = 31 * result + this.shortcuts.hashCode();
            return result;
        }

        private ImmutableSet<ImmutableList<String>> makeImmutable(Set<List<String>> keys) {
            return ImmutableSet.copyOf((Collection)Collections2.transform(keys, (Function)new Function<List<String>, ImmutableList<String>>(){

                public ImmutableList<String> apply(@Nullable List<String> input) {
                    return ImmutableList.copyOf(input);
                }
            }));
        }
    }
}

