/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.Email;
import com.atlassian.mail.MailThreader;
import com.atlassian.mail.MailUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class JiraMailThreader
implements MailThreader {
    private Issue issue;
    private static final AtomicInteger SEQUENCE_ID_FACTORY = new AtomicInteger();

    public JiraMailThreader(Issue issue) {
        this.issue = issue;
    }

    public void threadEmail(com.atlassian.mail.Email email) {
        if (email instanceof Email) {
            Email jiraEmail = (Email)email;
            ComponentAccessor.getMailThreadManager().threadNotificationEmail(jiraEmail, this.issue);
        }
    }

    public void storeSentEmail(com.atlassian.mail.Email email) {
    }

    public String getCustomMessageId(com.atlassian.mail.Email email) {
        return "JIRA." + this.issue.getId() + '.' + this.issue.getCreated().getTime() + '.' + SEQUENCE_ID_FACTORY.incrementAndGet() + '.' + System.currentTimeMillis() + "@" + MailUtils.getLocalHostName();
    }
}

