/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.comparator.LocaleSensitiveProjectNameComparator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ProjectClauseValuesGenerator
implements ClauseValuesGenerator {
    private final PermissionManager permissionManager;

    public ProjectClauseValuesGenerator(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList visibleProjects = new ArrayList(this.permissionManager.getProjectObjects(10, searcher));
        Collections.sort(visibleProjects, new LocaleSensitiveProjectNameComparator(this.getLocale(searcher)));
        ArrayList<ClauseValuesGenerator.Result> resultVals = new ArrayList<ClauseValuesGenerator.Result>();
        for (Project visibleProject : visibleProjects) {
            String lowerCaseKey;
            if (resultVals.size() == maxNumResults) break;
            String lowerCaseProjName = visibleProject.getName().toLowerCase();
            if (!this.valueMatchesProject(valuePrefix, lowerCaseProjName, lowerCaseKey = visibleProject.getKey().toLowerCase())) continue;
            resultVals.add(new ClauseValuesGenerator.Result(visibleProject.getName(), new String[]{visibleProject.getName(), " (" + visibleProject.getKey() + ")"}));
        }
        return new ClauseValuesGenerator.Results(resultVals);
    }

    private boolean valueMatchesProject(String valuePrefix, String lowerCaseProjName, String lowerCaseKey) {
        if (StringUtils.isBlank((String)valuePrefix)) {
            return true;
        }
        if (lowerCaseProjName.startsWith(valuePrefix.toLowerCase())) {
            return true;
        }
        return lowerCaseKey.startsWith(valuePrefix.toLowerCase());
    }

    Locale getLocale(User searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

