/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.core.util.Clock;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.jql.util.DateRange;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.util.dbc.Assertions;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@ThreadSafe
public final class JqlDateSupportImpl
implements JqlDateSupport {
    private static final Logger log = Logger.getLogger(JqlDateSupportImpl.class);
    private static final String YYYY_MM_DD1 = "yyyy/MM/dd";
    private static final String YYYY_MM_DD2 = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_HH_MM1 = "yyyy/MM/dd HH:mm";
    private static final String YYYY_MM_DD_HH_MM2 = "yyyy-MM-dd HH:mm";
    private static final String ATLASSIAN_DURATION = "AD";
    private static final String[] ACCEPTED_FORMATS = new String[]{"yyyy/MM/dd HH:mm", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy-MM-dd"};
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?:\\d+(?:\\.\\d+)?|\\.\\d+)(.)?", 2);
    private final Clock clock;
    private final TimeZoneManager timeZoneManager;

    public JqlDateSupportImpl(Clock clock, TimeZoneManager timeZoneManager) {
        this.timeZoneManager = timeZoneManager;
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
    }

    public JqlDateSupportImpl(TimeZoneManager timeZoneManager) {
        this(RealClock.getInstance(), timeZoneManager);
    }

    public Date convertToDate(String dateString) {
        Assertions.notNull((String)"dateString", (Object)dateString);
        String trimDate = StringUtils.trimToNull((String)dateString);
        if (trimDate != null) {
            Date returnDate = this.parseDuration(trimDate);
            if (returnDate != null) {
                return returnDate;
            }
            for (String acceptedFormat : ACCEPTED_FORMATS) {
                returnDate = this.parseDateForFormat(acceptedFormat, trimDate);
                if (returnDate == null) continue;
                return returnDate;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unable to parse JQL date '" + dateString + "'."));
        }
        return null;
    }

    public DateRange convertToDateRangeWithImpliedPrecision(String dateString) {
        Assertions.notNull((String)"dateString", (Object)dateString);
        String trimDate = StringUtils.trimToNull((String)dateString);
        if (trimDate != null) {
            Date returnDate = this.parseDuration(trimDate);
            if (returnDate != null) {
                return this.toPrecision(returnDate, ATLASSIAN_DURATION, dateString);
            }
            for (String acceptedFormat : ACCEPTED_FORMATS) {
                returnDate = this.parseDateForFormat(acceptedFormat, trimDate);
                if (returnDate == null) continue;
                return this.toPrecision(returnDate, acceptedFormat, null);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unable to parse JQL date '" + dateString + "'."));
        }
        return null;
    }

    private DateRange toPrecision(Date returnDate, String acceptedFormat, String dateString) {
        Precision precision = null;
        if (YYYY_MM_DD_HH_MM1.equals(acceptedFormat) || YYYY_MM_DD_HH_MM2.equals(acceptedFormat)) {
            precision = Precision.MINUTES;
        } else if (YYYY_MM_DD1.equals(acceptedFormat) || YYYY_MM_DD2.equals(acceptedFormat)) {
            precision = Precision.DAYS;
        } else if (ATLASSIAN_DURATION.equals(acceptedFormat)) {
            precision = this.reverseParseAtlassianDuration(dateString.toLowerCase(Locale.ENGLISH));
        }
        if (precision != null) {
            return precision.createRange(returnDate, this.timeZoneManager.getLoggedInUserTimeZone());
        }
        return new DateRange(returnDate, returnDate);
    }

    Precision reverseParseAtlassianDuration(String durationStr) {
        Precision rank = null;
        Matcher matcher = DURATION_PATTERN.matcher(durationStr);
        while (matcher.find()) {
            Precision current;
            String util = StringUtils.stripToNull((String)matcher.group(1));
            if (util == null || util.equals("m")) {
                return Precision.MINUTES;
            }
            if (util.equals("h")) {
                current = Precision.HOURS;
            } else if (util.equals("d") || util.equals("w")) {
                current = Precision.DAYS;
            } else {
                return Precision.MINUTES;
            }
            if (rank != null && rank.compareTo(current) <= 0) continue;
            rank = current;
        }
        return rank == null ? Precision.MINUTES : rank;
    }

    public Date convertToDate(Long dateLong) {
        return new Date((Long)Assertions.notNull((String)"dateLong", (Object)dateLong));
    }

    public DateRange convertToDateRange(Long dateLong) {
        Date date = new Date((Long)Assertions.notNull((String)"dateLong", (Object)dateLong));
        return new DateRange(date, date);
    }

    public String getIndexedValue(Date date) {
        return LuceneUtils.dateToString((Date)date);
    }

    public boolean validate(String dateString) {
        Assertions.notNull((String)"dateString", (Object)dateString);
        String trimDate = StringUtils.trimToNull((String)dateString);
        return trimDate != null && this.convertToDate(trimDate) != null;
    }

    public String getDateString(Date date) {
        SimpleDateFormat format;
        Assertions.notNull((String)"date", (Object)date);
        if (JqlDateSupportImpl.isMidnightDate(date, this.timeZoneManager)) {
            format = new SimpleDateFormat(YYYY_MM_DD2);
            format.setTimeZone(this.timeZoneManager.getLoggedInUserTimeZone());
        } else {
            format = new SimpleDateFormat(YYYY_MM_DD_HH_MM2);
            format.setTimeZone(this.timeZoneManager.getLoggedInUserTimeZone());
        }
        return format.format(date);
    }

    public static String getDurationString(long duration) {
        return DateUtils.getDurationStringWithNegative((long)TimeUnit.MILLISECONDS.toSeconds(duration));
    }

    private Date parseDuration(String str) {
        try {
            long offset = this.parseDurationOffset(str);
            Date currentDate = this.clock.getCurrentDate();
            return new Date(currentDate.getTime() + offset);
        }
        catch (InvalidDurationException e) {
            return null;
        }
        catch (NumberFormatException ne) {
            return null;
        }
    }

    private long parseDurationOffset(String str) throws InvalidDurationException {
        return TimeUnit.SECONDS.toMillis(DateUtils.getDurationWithNegative((String)str));
    }

    private Date parseDateForFormat(String format, String date) {
        String reFormat = Pattern.compile("d+|M+|H+|m+").matcher(Matcher.quoteReplacement(format)).replaceAll("\\\\d{1,2}");
        reFormat = Pattern.compile("y+").matcher(reFormat).replaceAll("\\\\d{4,}");
        if (Pattern.compile(reFormat).matcher(date).matches()) {
            SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance();
            sdf.applyPattern(format);
            sdf.setTimeZone(this.timeZoneManager.getLoggedInUserTimeZone());
            sdf.setLenient(false);
            try {
                return sdf.parse(date);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private static boolean isMidnightDate(Date value, TimeZoneManager timeZoneManager) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.setTimeZone(timeZoneManager.getLoggedInUserTimeZone());
        return cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0;
    }

    static enum Precision {
        MINUTES{

            @Override
            Calendar setToStart(Calendar calendar) {
                calendar.set(14, 0);
                calendar.set(13, 0);
                return calendar;
            }

            @Override
            Calendar setToEnd(Calendar calendar) {
                calendar.set(14, 0);
                calendar.set(13, 59);
                return calendar;
            }
        }
        ,
        HOURS{

            @Override
            Calendar setToStart(Calendar calendar) {
                MINUTES.setToStart(calendar).set(12, 0);
                return calendar;
            }

            @Override
            Calendar setToEnd(Calendar calendar) {
                MINUTES.setToEnd(calendar).set(12, 59);
                return calendar;
            }
        }
        ,
        DAYS{

            @Override
            Calendar setToStart(Calendar calendar) {
                HOURS.setToStart(calendar).set(11, 0);
                return calendar;
            }

            @Override
            Calendar setToEnd(Calendar calendar) {
                HOURS.setToEnd(calendar).set(11, 23);
                return calendar;
            }
        };


        abstract Calendar setToStart(Calendar var1);

        abstract Calendar setToEnd(Calendar var1);

        DateRange createRange(Date date, TimeZone zone) {
            Calendar calendar = Calendar.getInstance(zone);
            calendar.setTime(date);
            return new DateRange(this.setToStart(calendar).getTime(), this.setToEnd(calendar).getTime());
        }
    }
}

