/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.parser;

import com.atlassian.jira.jql.parser.JqlParseErrorMessages;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.parser.antlr.JqlLexer;
import com.atlassian.jira.jql.parser.antlr.JqlParser;
import com.atlassian.jira.jql.parser.antlr.RuntimeRecognitionException;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.jcip.annotations.ThreadSafe;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;

@ThreadSafe
public final class DefaultJqlQueryParser
implements JqlQueryParser {
    public final Query parseQuery(String jqlQuery) throws JqlParseException {
        Assertions.notNull((String)"jqlQuery", (Object)jqlQuery);
        JqlParser.query_return aReturn = this.parseClause(jqlQuery);
        OrderByImpl orderByClause = aReturn.order == null ? new OrderByImpl(new SearchSort[0]) : aReturn.order;
        return new QueryImpl(aReturn.clause, (OrderBy)orderByClause, jqlQuery);
    }

    public boolean isValidFieldName(String fieldName) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        try {
            if (JqlCustomFieldId.isJqlCustomFieldId((String)fieldName)) {
                return true;
            }
            return StringUtils.equals((String)fieldName, (String)this.createJqlParser(fieldName).fieldCheck());
        }
        catch (RecognitionException e) {
            return false;
        }
        catch (RuntimeRecognitionException e) {
            return false;
        }
    }

    public boolean isValidFunctionArgument(String argument) {
        Assertions.notNull((String)"argument", (Object)argument);
        try {
            return StringUtils.equals((String)argument, (String)this.createJqlParser(argument).argumentCheck());
        }
        catch (RecognitionException e) {
            return false;
        }
        catch (RuntimeRecognitionException e) {
            return false;
        }
    }

    public boolean isValidFunctionName(String functionName) {
        Assertions.notNull((String)"functionName", (Object)functionName);
        try {
            return StringUtils.equals((String)functionName, (String)this.createJqlParser(functionName).funcNameCheck());
        }
        catch (RecognitionException e) {
            return false;
        }
        catch (RuntimeRecognitionException e) {
            return false;
        }
    }

    public boolean isValidValue(String value) {
        Assertions.notNull((String)"value", (Object)value);
        try {
            return this.isLong(value) || StringUtils.equals((String)value, (String)this.createJqlParser(value).stringValueCheck());
        }
        catch (RecognitionException e) {
            return false;
        }
        catch (RuntimeRecognitionException e) {
            return false;
        }
    }

    private JqlParser.query_return parseClause(String clauseString) throws JqlParseException {
        try {
            try {
                return this.createJqlParser(clauseString).query();
            }
            catch (RecognitionException e) {
                throw new JqlParseException(JqlParseErrorMessages.genericParseError(e.token), (Throwable)e);
            }
        }
        catch (RuntimeRecognitionException e) {
            throw new JqlParseException(e.getParseErrorMessage(), (Throwable)e);
        }
    }

    private JqlParser createJqlParser(String clauseString) throws RuntimeRecognitionException {
        JqlLexer lexer = new JqlLexer((CharStream)new ANTLRStringStream(clauseString));
        return new JqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
    }

    private boolean isLong(String longString) {
        try {
            Long.parseLong(longString);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        DefaultJqlQueryParser parser = new DefaultJqlQueryParser();
        String line = reader.readLine();
        while (line != null) {
            try {
                Query query = parser.parseQuery(line);
                System.out.printf("Got query: '%s'%n", query);
            }
            catch (JqlParseException e) {
                System.out.println("Parse error occured: " + e.getParseErrorMessage());
                e.printStackTrace(System.out);
            }
            catch (Exception e) {
                System.err.println("Unexpected error occured: " + e);
                e.printStackTrace(System.err);
            }
            line = reader.readLine();
        }
    }
}

