/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.login;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jelly.ActionTagSupport;
import com.atlassian.jira.jelly.WebWorkAdaptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import webwork.action.ActionContext;

public class Login
extends ActionTagSupport {
    private static final transient Logger log = Logger.getLogger(Login.class);
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private boolean hasPreviousUser = false;
    private User previousUser = null;
    private boolean hasPreviousUsername = false;
    private String previousUsername = null;
    private User previousAuthContextUser = null;
    private final JiraAuthenticationContext authenticationContext;
    private final UserManager userManager;

    public Login(JiraAuthenticationContext authenticationContext, UserManager userManager) {
        this.authenticationContext = authenticationContext;
        this.userManager = userManager;
        this.setActionName("TestLogin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTag(XMLOutput output) throws JellyTagException {
        User user;
        log.debug((Object)"TestLogin.doTag");
        String username = this.getProperty(KEY_USERNAME);
        String password = this.getProperty(KEY_PASSWORD);
        ActionContext oldContext = null;
        if (!this.mapContainsAll(this.getRequiredProperties(), this.getProperties())) {
            if (username == null) {
                user = this.authenticationContext.getLoggedInUser();
                if (user == null) {
                    throw new MissingAttributeException("User not logged in you must specify: username = 'null' and password = " + password);
                }
                this.setContextVariables(user);
            } else {
                user = this.userManager.getUser(username);
                if (user == null) {
                    throw new MissingAttributeException("User not logged in you must specify: username = " + username + " and password = " + password);
                }
                this.previousAuthContextUser = this.authenticationContext.getLoggedInUser();
                this.setContextVariables(user);
            }
        } else {
            if (username == null || username.length() == 0 || password == null || password.length() == 0) {
                throw new MissingAttributeException("username = " + username + ", password = " + password);
            }
            oldContext = ActionContext.getContext();
            ActionContext.setContext((ActionContext)new ActionContext());
            try {
                this.previousAuthContextUser = this.authenticationContext.getLoggedInUser();
                user = this.userManager.getUser(username);
                if (this.getWebWorkAdaptor().authenticateUser(this, username, password, output)) {
                    this.authenticationContext.setLoggedInUser(user);
                    this.setContextVariables(user);
                }
            }
            catch (Exception e) {
                try {
                    WebWorkAdaptor.writeErrorToXmlOutput(output, new StringBuffer("Login"), "User: " + username + " does not exist", (TagSupport)this);
                }
                catch (SAXException e1) {
                    throw new JellyTagException((Throwable)e1);
                }
            }
        }
        try {
            Script body = this.getBody();
            if (body != null) {
                body.run(this.getContext(), output);
            }
        }
        finally {
            this.endTagExecution(output);
            if (oldContext != null) {
                ActionContext.setContext((ActionContext)oldContext);
            }
        }
    }

    private void setContextVariables(User user) {
        User prevUser = (User)this.getContext().getVariable("jelly.user");
        String prevUserName = (String)this.getContext().getVariable("jelly.username");
        this.setPreviousUser(prevUser);
        this.getContext().setVariable("jelly.user", (Object)user);
        this.setPreviousUsername(prevUserName);
        this.getContext().setVariable("jelly.username", (Object)user.getName());
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.authenticationContext.setLoggedInUser(this.previousAuthContextUser);
        if (this.hasPreviousUser) {
            this.getContext().setVariable("jelly.user", (Object)this.getPreviousUser());
        }
        if (this.hasPreviousUsername) {
            this.getContext().setVariable("jelly.username", (Object)this.getPreviousUsername());
        }
    }

    @Override
    public String[] getRequiredContextVariables() {
        return new String[0];
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_USERNAME, KEY_PASSWORD};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[]{"jelly.user", "jelly.username"};
    }

    private User getPreviousUser() {
        return this.previousUser;
    }

    private void setPreviousUser(User previousUser) {
        this.hasPreviousUser = true;
        this.previousUser = previousUser;
    }

    private String getPreviousUsername() {
        return this.previousUsername;
    }

    private void setPreviousUsername(String previousUsername) {
        this.hasPreviousUsername = true;
        this.previousUsername = previousUsername;
    }
}

