/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.jelly.UserAwareDynaBeanTagSupport;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.ArrayList;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;

public class GetAssociatedSchemes
extends UserAwareDynaBeanTagSupport {
    public static final String KEY_SCHEME_TYPE = "schemetype";
    public static final String SCHEME_TYPE_PERMISSION = "permission";
    public static final String SCHEME_TYPE_NOTIFICATION = "notification";

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRoleService projectRoleService = ComponentManager.getComponentInstanceOfType(ProjectRoleService.class);
        ProjectRole projectRole = this.getProjectRole(errorCollection);
        String schemeType = (String)this.getProperties().get(KEY_SCHEME_TYPE);
        ArrayList schemes = new ArrayList();
        if (SCHEME_TYPE_NOTIFICATION.equals(schemeType)) {
            schemes.addAll(projectRoleService.getAssociatedNotificationSchemes(this.getUser(), projectRole, (ErrorCollection)errorCollection));
        } else if (SCHEME_TYPE_PERMISSION.equals(schemeType)) {
            schemes.addAll(projectRoleService.getAssociatedPermissionSchemes(this.getUser(), projectRole, (ErrorCollection)errorCollection));
        }
        if (errorCollection.hasAnyErrors()) {
            throw new JellyTagException(errorCollection.toString());
        }
        String variableName = (String)this.getProperties().get("var");
        this.getContext().setVariable(variableName, schemes);
        this.invokeBody(output);
    }

    protected ProjectRole getProjectRole(SimpleErrorCollection errorCollection) {
        ProjectRoleService projectRoleService = ComponentManager.getComponentInstanceOfType(ProjectRoleService.class);
        String projectRoleIdAsString = (String)this.getProperties().get("projectroleid");
        Long projectRoleId = null;
        if (StringUtils.isNotBlank((String)projectRoleIdAsString)) {
            projectRoleId = new Long(projectRoleIdAsString);
        }
        return projectRoleService.getProjectRole(this.getUser(), projectRoleId, (ErrorCollection)errorCollection);
    }
}

